<?php
// =================================================================
// BLOCO DE INÍCIO PADRÃO
// =================================================================
include 'verifica_login.php';
include 'conexao.php';
$id_escola = $_SESSION['id_escola'];
$id_usuario = $_SESSION['usuario_id']; // ID do utilizador logado
// =================================================================

// --- LÓGICA PARA ADICIONAR, E ATUALIZAR TAREFAS ---

// Marcar como concluída
if (isset($_GET['marcar_concluida']) && is_numeric($_GET['marcar_concluida'])) {
    $tarefa_id = (int)$_GET['marcar_concluida'];
    $stmt = $conn->prepare("UPDATE tarefas SET status = 'concluida' WHERE id = ? AND id_usuario = ?");
    $stmt->bind_param("ii", $tarefa_id, $id_usuario);
    $stmt->execute();
    header("Location: tarefas.php"); // Redireciona para limpar a URL
    exit;
}

// Adicionar nova tarefa
if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['descricao_tarefa'])) {
    $descricao = trim($_POST['descricao_tarefa']);
    $stmt = $conn->prepare("INSERT INTO tarefas (id_escola, id_usuario, descricao) VALUES (?, ?, ?)");
    $stmt->bind_param("iis", $id_escola, $id_usuario, $descricao);
    $stmt->execute();
    header("Location: tarefas.php");
    exit;
}

// Buscar todas as tarefas do utilizador logado
$stmt = $conn->prepare("SELECT id, descricao, status, data_criacao FROM tarefas WHERE id_usuario = ? ORDER BY data_criacao DESC");
$stmt->bind_param("i", $id_usuario);
$stmt->execute();
$result_tarefas = $stmt->get_result();
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8">
<title>Minhas Tarefas</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="style.css">
<style>
    .task-list { list-style: none; padding: 0; }
    .task-item { display: flex; align-items: center; justify-content: space-between; padding: 12px; border-bottom: 1px solid var(--border-color); }
    .task-item:last-child { border-bottom: none; }
    .task-item.concluida .task-desc { text-decoration: line-through; color: var(--muted-text); }
    .task-desc { flex-grow: 1; }
    .task-actions a { font-size: 12px; }
</style>
</head>
<body>
<div class="app-container">
    <?php include 'menu.php'; ?>
    <main class="main-content">
        <h1>Minhas Tarefas</h1>

        <div class="card">
            <h2>Adicionar Nova Tarefa</h2>
            <form method="post" style="display: flex; gap: 10px;">
                <input type="text" name="descricao_tarefa" placeholder="Descreva a sua tarefa..." required style="flex-grow: 1;">
                <button type="submit" class="btn primary">Adicionar</button>
            </form>
        </div>

        <div class="card">
            <h2>Lista de Tarefas</h2>
            <ul class="task-list">
                <?php if ($result_tarefas->num_rows > 0): ?>
                    <?php while($tarefa = $result_tarefas->fetch_assoc()): ?>
                        <li class="task-item <?= $tarefa['status'] == 'concluida' ? 'concluida' : '' ?>">
                            <span class="task-desc"><?= htmlspecialchars($tarefa['descricao']) ?></span>
                            <div class="task-actions">
                                <?php if ($tarefa['status'] == 'pendente'): ?>
                                    <a href="tarefas.php?marcar_concluida=<?= $tarefa['id'] ?>" class="btn secondary" style="padding: 6px 10px;">Concluir</a>
                                <?php else: ?>
                                    <span style="font-size: 12px; color: var(--success-color); font-weight: bold;">Concluída</span>
                                <?php endif; ?>
                            </div>
                        </li>
                    <?php endwhile; ?>
                <?php else: ?>
                    <li class="task-item">Nenhuma tarefa encontrada. Adicione uma acima!</li>
                <?php endif; ?>
            </ul>
        </div>
        
        <?php include 'footer.php'; ?>
    </main>
</div>
</body>
</html>