<?php
// =================================================================
// BLOCO DE INÍCIO PADRÃO
// =================================================================
include 'verifica_login.php';
include 'conexao.php';
$id_escola = $_SESSION['id_escola'];
// =================================================================

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    die("Acesso inválido.");
}

$id_cancelamento = (int)($_GET['id'] ?? 0);
if ($id_cancelamento <= 0) {
    die("ID de cancelamento inválido.");
}

function br_to_float($v) {
    $v = trim((string)$v);
    if ($v === '') return 0.0;
    $v = str_replace('.', '', $v);
    $v = str_replace(',', '.', $v);
    return (float)$v;
}

// Coleta de dados do formulário
$aluno_nome         = trim($_POST['aluno_nome'] ?? '');
$curso_id           = (int)($_POST['curso_id'] ?? 0);
$parcelas_contrato  = (int)($_POST['num_parcelas'] ?? 0);
$valor_parcela      = br_to_float($_POST['valor_parcela'] ?? 0);
$aulas_estudadas    = (int)($_POST['aulas_estudadas'] ?? 0);
$duracao_aula       = br_to_float($_POST['duracao_aula'] ?? 0);
$total_pago         = br_to_float($_POST['total_pago'] ?? 0);
$percentual_multa   = br_to_float($_POST['perc_multa'] ?? 10);
$historico_conversa = trim($_POST['historico_conversa'] ?? '');

// Recálculo seguro no backend
$stmt_curso = $conn->prepare("SELECT horas_total FROM cursos WHERE id = ? AND id_escola = ?");
$stmt_curso->bind_param("ii", $curso_id, $id_escola);
$stmt_curso->execute();
$curso_data = $stmt_curso->get_result()->fetch_assoc();
$horas_total_curso = $curso_data['horas_total'] ?? 0;

$valor_total_curso   = $parcelas_contrato * $valor_parcela;
$valor_hora_aula     = ($horas_total_curso > 0) ? ($valor_total_curso / $horas_total_curso) : 0;
$horas_estudadas     = $aulas_estudadas * $duracao_aula;
$valor_estudado_sala = $horas_estudadas * $valor_hora_aula;
$debito_credito      = $valor_estudado_sala - $total_pago;
$valor_multa         = ($percentual_multa / 100.0) * $valor_total_curso;
$debitoPositivo      = $debito_credito > 0 ? $debito_credito : 0;
$valor_total_a_pagar = $debitoPositivo + $valor_multa;

$sql = "UPDATE cancelamentos SET 
            aluno_nome = ?, curso_id = ?, parcelas_contrato = ?, valor_parcela = ?, valor_hora_aula = ?, 
            aulas_estudadas = ?, duracao_aula = ?, horas_estudadas = ?, valor_estudado_sala = ?, 
            parcelas_pagas = ?, valor_a_pagar_escola = ?, percentual_multa = ?, valor_total_curso = ?, 
            valor_multa = ?, valor_total_a_pagar = ?, historico_conversa = ?
        WHERE 
            id = ? AND id_escola = ?";

$stmt = $conn->prepare($sql);

if ($stmt === false) {
    die("Erro ao preparar a consulta de UPDATE: " . $conn->error);
}

// CORREÇÃO FINAL NA CONTAGEM DOS PARÂMETROS
$stmt->bind_param("siididdddddddddssii",
    $aluno_nome, $curso_id, $parcelas_contrato, $valor_parcela, $valor_hora_aula, $aulas_estudadas,
    $duracao_aula, $horas_estudadas, $valor_estudado_sala, $total_pago, $debito_credito,
    $percentual_multa, $valor_total_curso, $valor_multa, $valor_total_a_pagar, $historico_conversa,
    $id_cancelamento, $id_escola
);

if ($stmt->execute()) {
    header("Location: listar_cancelamento.php?msg=sucesso_edicao");
    exit;
} else {
    die("Erro ao executar o UPDATE: " . $stmt->error);
}

?>