<?php
include 'conexao.php';
include 'menu.php';
$erro = '';
$sucesso = '';

// Valores padrão do formulário
$id_professor = '';
$data_ponto   = date('Y-m-d');
$hora_entrada = date('H:i');
$hora_saida   = '';
$observacoes  = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id_professor = $_POST['id_professor'] ?? '';
    $data_ponto   = $_POST['data_ponto'] ?? date('Y-m-d');
    $hora_entrada = $_POST['hora_entrada'] ?? '';
    $hora_saida   = $_POST['hora_saida'] ?? '';
    $observacoes  = $_POST['observacoes'] ?? '';

    if (empty($id_professor) || empty($data_ponto)) {
        $erro = "Selecione um professor e uma data.";
    } elseif (!empty($hora_entrada) && !empty($hora_saida) && $hora_saida < $hora_entrada) {
        $erro = "A hora de saída não pode ser menor que a de entrada.";
    } else {
        // Verifica se professor existe
        $checkProf = $conn->prepare("SELECT id FROM professores WHERE id = ?");
        $checkProf->bind_param("i", $id_professor);
        $checkProf->execute();
        $resProf = $checkProf->get_result();
        if ($resProf->num_rows === 0) {
            $erro = "Professor não encontrado.";
        } else {
            // Evita registro duplicado no mesmo dia
            $checkDup = $conn->prepare("SELECT id FROM ponto WHERE id_professor = ? AND data_ponto = ?");
            $checkDup->bind_param("is", $id_professor, $data_ponto);
            $checkDup->execute();
            if ($checkDup->get_result()->num_rows > 0) {
                $erro = "Já existe um ponto registrado para este professor nesta data.";
            } else {
                // Insere o ponto
                $stmt = $conn->prepare("INSERT INTO ponto (id_professor, data_ponto, hora_entrada, hora_saida, observacoes) VALUES (?, ?, ?, ?, ?)");
                $stmt->bind_param("issss", $id_professor, $data_ponto, $hora_entrada, $hora_saida, $observacoes);
                if ($stmt->execute()) {
                    $sucesso = "Ponto registrado com sucesso!";
                    // Limpar apenas alguns campos, mantendo data/hora padrão
                    $id_professor = '';
                    $hora_saida = '';
                    $observacoes = '';
                } else {
                    $erro = "Erro ao registrar ponto: " . $stmt->error;
                }
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <title>Registrar Ponto</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <style>
    body { font-family: sans-serif; background-color: #f4f4f4; margin: 0; }
    .container { max-width: 600px; margin: 40px auto; background: white; padding: 20px; border-radius: 8px; box-shadow: 0 2px 6px rgba(0,0,0,0.1); }
    h2 { margin-bottom: 20px; }
    label { display: block; margin-top: 10px; }
    input, select, textarea { width: 100%; padding: 8px; margin-top: 5px; font-size: 14px; border: 1px solid #ccc; border-radius: 4px; }
    button { margin-top: 20px; padding: 10px 20px; background: #2ecc71; color: white; border: none; border-radius: 5px; cursor: pointer; }
    button:hover { background: #27ae60; }
    .msg-erro { background-color: #e74c3c; color: white; padding: 10px; margin-bottom: 15px; border-radius: 5px; }
    .msg-sucesso { background-color: #27ae60; color: white; padding: 10px; margin-bottom: 15px; border-radius: 5px; }
  </style>
</head>
<body>
  <div class="container">
    <h2>Registrar Novo</h2>

    <?php if ($erro): ?>
      <div class="msg-erro"><?= htmlspecialchars($erro) ?></div>
    <?php endif; ?>

    <?php if ($sucesso): ?>
      <div class="msg-sucesso"><?= htmlspecialchars($sucesso) ?></div>
    <?php endif; ?>

    <form method="post" action="">
      <label for="id_professor">Instrutor</label>
      <select name="id_professor" id="id_professor" required>
        <option value="">-- Selecione --</option>
        <?php
        $profQuery = $conn->query("SELECT id, nome, escola FROM professores ORDER BY nome");
        while ($p = $profQuery->fetch_assoc()) {
          $selected = ($id_professor == $p['id']) ? 'selected' : '';
          echo "<option value='{$p['id']}' $selected>" . htmlspecialchars($p['nome']) . " - " . htmlspecialchars($p['escola']) . "</option>";
        }
        ?>
      </select>

      <label for="data_ponto">Data</label>
      <input type="date" name="data_ponto" id="data_ponto" value="<?= htmlspecialchars($data_ponto) ?>" required>

      <label for="hora_entrada">Hora de Entrada</label>
      <input type="time" name="hora_entrada" id="hora_entrada" value="<?= htmlspecialchars($hora_entrada) ?>">

      <label for="hora_saida">Hora de Saída</label>
      <input type="time" name="hora_saida" id="hora_saida" value="<?= htmlspecialchars($hora_saida) ?>">

      <label for="observacoes">Observações</label>
      <textarea name="observacoes" id="observacoes"><?= htmlspecialchars($observacoes) ?></textarea>

      <button type="submit">Salvar Ponto</button>
    </form>
  </div>
</body>
</html>
