<?php
include 'conexao.php';
session_start();

$mensagem_erro = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Coleta dos dados da ESCOLA
    $escola_nome = trim($_POST['escola_nome'] ?? '');
    $escola_cnpj = trim($_POST['escola_cnpj'] ?? '');

    // Coleta dos dados do UTILIZADOR
    $usuario_nome = trim($_POST['usuario_nome'] ?? '');
    $usuario_email = trim($_POST['usuario_email'] ?? '');
    $senha = $_POST['senha'] ?? '';
    $senha_confirm = $_POST['senha_confirm'] ?? '';

    // Validações básicas
    if ($senha !== $senha_confirm) {
        $mensagem_erro = "As senhas não coincidem.";
    } elseif (empty($escola_nome) || empty($usuario_nome) || empty($usuario_email) || empty($senha)) {
        $mensagem_erro = "Por favor, preencha todos os campos obrigatórios.";
    } else {
        // Inicia a transação
        $conn->begin_transaction();

        try {
            // 1. Inserir a nova ESCOLA
            $sql_escola = "INSERT INTO escolas (nome, cnpj) VALUES (?, ?)";
            $stmt_escola = $conn->prepare($sql_escola);
            $stmt_escola->bind_param("ss", $escola_nome, $escola_cnpj);
            $stmt_escola->execute();
            
            // Pega o ID da escola que acabámos de criar
            $nova_escola_id = $conn->insert_id;
            if ($nova_escola_id == 0) {
                throw new Exception("Falha ao criar a escola.");
            }

            // 2. Inserir o novo UTILIZADOR, já ligado à nova escola
            $senha_hash = password_hash($senha, PASSWORD_DEFAULT);
            // O novo utilizador será um utilizador padrão (nível 1). Você (Master) pode promovê-lo depois.
            $sql_usuario = "INSERT INTO usuarios (id_escola, nome, email, nivel, senha) VALUES (?, ?, ?, 1, ?)";
            $stmt_usuario = $conn->prepare($sql_usuario);
            $stmt_usuario->bind_param("isss", $nova_escola_id, $usuario_nome, $usuario_email, $senha_hash);
            $stmt_usuario->execute();
            
            // Se tudo correu bem, confirma as operações
            $conn->commit();

            // Redireciona para o login com uma mensagem de sucesso
            header("Location: login.php?registo=sucesso");
            exit;

        } catch (Exception $e) {
            // Se algo deu errado, desfaz todas as operações
            $conn->rollback();
            if ($conn->errno == 1062) { // Código de erro para entrada duplicada (email já existe)
                $mensagem_erro = "Este endereço de e-mail já está a ser utilizado.";
            } else {
                $mensagem_erro = "Ocorreu um erro ao processar o registo. Tente novamente. Erro: " . $e->getMessage();
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8">
<title>Registar Nova Escola</title>
<style>
/* Estilos para a página de login */
:root {
    --bg: #f6f8fb; --card: #fff; --muted: #64748b; --text: #0f172a;
    --accent: #4f46e5; --bad: #ef4444; --border: #e5e7eb;
}
* { box-sizing: border-box; }
body { font-family: Inter, Segoe UI, Roboto, Arial, sans-serif; background: var(--bg); color: var(--text); margin: 0; display: flex; align-items: center; justify-content: center; min-height: 100vh; }
.login-container { width: 100%; max-width: 400px; padding: 16px; }
.card { background: var(--card); border: 1px solid var(--border); border-radius: 14px; padding: 32px; box-shadow: 0 10px 30px rgba(15,23,42,.04); }
h1 { font-size: 24px; text-align: center; margin: 0 0 24px; }
label { font-size: 13px; color: var(--muted); display: block; margin-bottom: 6px; font-weight: 500; }
input { width: 100%; padding: 12px; border: 1px solid var(--border); border-radius: 10px; font-size: 14px; margin-bottom: 16px; }
.btn { width: 100%; border: none; border-radius: 10px; padding: 14px; cursor: pointer; font-weight: 600; font-size: 15px; }
.btn.primary { background: var(--accent); color: #fff; }
.msg.err { text-align: center; padding: 12px; border-radius: 10px; margin-bottom: 16px; background: #fef2f2; color: #991b1b; }
</style>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="style.css">
</head>
<body>
<div class="login-container" style="max-width: 500px;">
    <div class="card">
        <h1>Registar Nova Escola</h1>
        <?php if ($mensagem_erro): ?><div class="msg err"><?= htmlspecialchars($mensagem_erro) ?></div><?php endif; ?>
        <form method="post">
            <fieldset style="border:1px solid #ccc; border-radius: 8px; padding: 16px; margin-bottom: 16px;">
                <legend style="padding: 0 8px; font-weight: 600;">Dados da Escola</legend>
                <div>
                    <label for="escola_nome">Nome da Escola</label>
                    <input type="text" name="escola_nome" id="escola_nome" required>
                </div>
                <div>
                    <label for="escola_cnpj">CNPJ (Opcional)</label>
                    <input type="text" name="escola_cnpj" id="escola_cnpj">
                </div>
            </fieldset>

            <fieldset style="border:1px solid #ccc; border-radius: 8px; padding: 16px;">
                <legend style="padding: 0 8px; font-weight: 600;">Dados do Utilizador Administrador</legend>
                <div>
                    <label for="usuario_nome">Seu Nome Completo</label>
                    <input type="text" name="usuario_nome" id="usuario_nome" required>
                </div>
                <div>
                    <label for="usuario_email">Seu E-mail (será o seu login)</label>
                    <input type="email" name="usuario_email" id="usuario_email" required>
                </div>
                <div>
                    <label for="senha">Senha</label>
                    <input type="password" name="senha" id="senha" required>
                </div>
                <div>
                    <label for="senha_confirm">Confirmar Senha</label>
                    <input type="password" name="senha_confirm" id="senha_confirm" required>
                </div>
            </fieldset>
            
            <button type="submit" class="btn primary" style="margin-top: 20px;">Criar Conta</button>
        </form>
        <div style="text-align: center; margin-top: 16px; font-size: 14px;">
            Já tem uma conta? <a href="login.php">Entrar</a>
        </div>
    </div>
</div>
</body>
</html>