<?php
include 'verifica_login.php';

// 2. A Conexão: Conecta ao banco de dados.
include 'conexao.php';

// 3. O Contexto: Pega as informações do usuário e define as variáveis padrão.
$id_escola = $_SESSION['id_escola'];
$nome_usuario = $_SESSION['usuario_nome'];
$nivel_usuario = $_SESSION['usuario_nivel'];

if ($id_escola <= 0) {
    die("Erro: ID da escola não identificado. Faça o login para continuar.");
}

// --- LÓGICA DE FILTRAGEM SEGURA ---
$params = [$id_escola]; // O primeiro parâmetro sempre será o id_escola
$types = 'i'; // 'i' para integer
$filtros = [];

// Base da query
$sql = "SELECT id, nome, cpf, telefone FROM professores WHERE id_escola = ?";

// Adiciona filtros dinamicamente
if (!empty($_GET['nome'])) {
    $filtros[] = "nome LIKE ?";
    $params[] = '%' . $_GET['nome'] . '%';
    $types .= 's';
}
if (!empty($_GET['data_adm_de'])) {
    $filtros[] = "data_admissao >= ?";
    $params[] = $_GET['data_adm_de'];
    $types .= 's';
}
if (!empty($_GET['data_adm_ate'])) {
    $filtros[] = "data_admissao <= ?";
    $params[] = $_GET['data_adm_ate'];
    $types .= 's';
}
if (!empty($_GET['data_dem_de'])) {
    $filtros[] = "data_demissao >= ?";
    $params[] = $_GET['data_dem_de'];
    $types .= 's';
}
if (!empty($_GET['data_dem_ate'])) {
    $filtros[] = "data_demissao <= ?";
    $params[] = $_GET['data_dem_ate'];
    $types .= 's';
}

// Junta os filtros na query principal
if (count($filtros) > 0) {
    $sql .= ' AND ' . implode(' AND ', $filtros);
}

$sql .= " ORDER BY nome";

// Prepara e executa a query
$stmt = $conn->prepare($sql);
if ($stmt) {
    $stmt->bind_param($types, ...$params);
    $stmt->execute();
    $result = $stmt->get_result();
} else {
    // Tratar erro na preparação da query
    $result = null;
    echo "Erro na consulta SQL.";
}

?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8">
<title>Lista de Professores</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<style>
/* Estilo 'Dashboard' Padrão */
:root {
    --bg: #f6f8fb; --card: #fff; --muted: #64748b; --text: #0f172a;
    --accent: #4f46e5; --ok: #10b981; --bad: #ef4444; --border: #e5e7eb;
}
* { box-sizing: border-box; }
body { font-family: Inter, Segoe UI, Roboto, Arial, sans-serif; background: var(--bg); color: var(--text); margin: 0; }
.container { max-width: 1100px; margin: 24px auto; padding: 16px; }
h1 { font-size: 22px; margin: 0 0 12px; }
.card { background: var(--card); border: 1px solid var(--border); border-radius: 14px; padding: 20px; box-shadow: 0 10px 30px rgba(15,23,42,.04); margin-bottom: 20px; }
label { font-size: 13px; color: var(--muted); display: block; margin-bottom: 6px; font-weight: 500; }
input, select { width: 100%; padding: 10px 12px; border: 1px solid var(--border); border-radius: 10px; font-size: 14px; background: #fff; }
.btn { border: none; border-radius: 10px; padding: 12px 20px; cursor: pointer; font-weight: 600; font-size: 14px; text-decoration: none; display: inline-block; text-align: center; }
.btn.primary { background: var(--accent); color: #fff; }
.btn.secondary { background: #eef2ff; color: var(--accent); }
.header-actions { display: flex; justify-content: space-between; align-items: center; margin-bottom: 16px; }
/* Filtros */
.filter-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(150px, 1fr)); gap: 16px; align-items: flex-end; }
/* Tabela */
table { width: 100%; border-collapse: collapse; }
th, td { padding: 12px 16px; text-align: left; border-bottom: 1px solid var(--border); }
th { font-size: 12px; color: var(--muted); text-transform: uppercase; }
td { color: #334155; }
.actions-cell a { margin-right: 8px; font-size: 13px; text-decoration: none; color: var(--accent); font-weight: 500; }
.actions-cell a.delete { color: var(--bad); }
.total-count { margin-top: 16px; font-weight: 500; color: var(--muted); }
</style>
</head>
<body> <br></br>
    <br></br><div class="app-container">
        <?php include 'menu.php'; // Nosso menu lateral ?>

        <main class="main-content">
            </main>

        <?php include 'footer.php'; // <<-- ADICIONE ESTA LINHA AQUI ?>
    </div>

    <div class="header-actions">
        <h1>Lista de Professores</h1>
        <a class="btn primary" href="cadastro_professor.php">+ Novo Professor</a>
    </div>

    <div class="card">
        <form method="get" autocomplete="off">
            <div class="filter-grid">
                <div>
                    <label for="nome">Nome do professor</label>
                    <input type="text" id="nome" name="nome" value="<?= htmlspecialchars($_GET['nome'] ?? '') ?>">
                </div>
                <div>
                    <label for="data_adm_de">Admissão de</label>
                    <input type="date" id="data_adm_de" name="data_adm_de" value="<?= htmlspecialchars($_GET['data_adm_de'] ?? '') ?>">
                </div>
                <div>
                    <label for="data_adm_ate">Admissão até</label>
                    <input type="date" id="data_adm_ate" name="data_adm_ate" value="<?= htmlspecialchars($_GET['data_adm_ate'] ?? '') ?>">
                </div>
                <div>
                    <label for="data_dem_de">Demissão de</label>
                    <input type="date" id="data_dem_de" name="data_dem_de" value="<?= htmlspecialchars($_GET['data_dem_de'] ?? '') ?>">
                </div>
                <div>
                    <label for="data_dem_ate">Demissão até</label>
                    <input type="date" id="data_dem_ate" name="data_dem_ate" value="<?= htmlspecialchars($_GET['data_dem_ate'] ?? '') ?>">
                </div>
                <div>
                    <button type="submit" class="btn secondary" style="width: 100%;">Filtrar</button>
                </div>
            </div>
        </form>
    </div>

    <div class="card">
        <table>
            <thead>
                <tr>
                    <th>Nome</th>
                    <th>Telefone</th>
                    <th>Ações</th>
                </tr>
            </thead>
            <tbody>
                <?php if ($result && $result->num_rows > 0): ?>
                    <?php while ($row = $result->fetch_assoc()): ?>
                        <tr>
                            <td><?= htmlspecialchars($row['nome']) ?></td>
                            <td><?= htmlspecialchars($row['telefone']) ?></td>
                            <td class="actions-cell">
                                <a href="editar_professor.php?id=<?= $row['id'] ?>">Editar</a>
                                <a href="gerador_contrato.php?id_prof=<?= $row['id'] ?>&id_modelo=1" target="_blank">Contrato</a>
                                <a href="excluir_professor.php?id=<?= $row['id'] ?>" class="delete" onclick="return confirm('Tem certeza que deseja excluir este professor?')">Excluir</a>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="3">Nenhum professor encontrado com esses critérios.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
        <?php if ($result): ?>
            <div class="total-count">
                Total de professores encontrados: <?= $result->num_rows ?>
            </div>
        <?php endif; ?>
    </div>
</div>
</body>
</html>