<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
include 'conexao.php';
?>
<!DOCTYPE html>
<html lang="pt-br">
     <link rel="stylesheet" href="assets/css/style1.css">
<head>
  <meta charset="UTF-8">
  <title>Controle de Ponto</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <style>
    body {
      font-family: Arial, sans-serif;
      background-color: #f4f4f4;
      margin: 0;
    }
    .content {
      max-width: 1200px;
      margin: auto;
      background: #fff;
      padding: 20px;
    }
    h1 {
      margin-bottom: 20px;
    }
    .btn {
      display: inline-block;
      padding: 8px 15px;
      background: #2ecc71;
      color: #fff;
      text-decoration: none;
      border-radius: 4px;
      margin-bottom: 10px;
    }
    .btn:hover {
      background: #27ae60;
    }
    .filtro {
      margin-bottom: 20px;
      padding: 10px;
      background: #f9f9f9;
      border: 1px solid #ddd;
    }
    table {
      width: 100%;
      border-collapse: collapse;
    }
    table th, table td {
      padding: 8px;
      border: 1px solid #ccc;
      text-align: left;
    }
    table th {
      background: #eee;
    }
    .acoes a {
      margin-right: 8px;
      text-decoration: none;
      padding: 5px 8px;
      border-radius: 4px;
    }
    .editar { background: #3498db; color: #fff; }
    .excluir { background: #e74c3c; color: #fff; }
    .calcular { background: #9b59b6; color: #fff; }
  </style>
</head>
<body>
    
    <div class="app-container">
        <?php include 'menu.php'; // Nosso menu lateral ?>

        <main class="main-content">
            </main>

        <?php include 'footer.php'; // <<-- ADICIONE ESTA LINHA AQUI ?>
    </div>    
    
<div class="content">
    <br></br><br></br>
  <h1>Controle de Ponto</h1>
  <a class="btn" href="registro_ponto.php">+ Registrar Novo Ponto</a>
  <a class="btn" href="calcular_horas.php">Relatório de Pagamento </a>

  <form method="get" class="filtro">
    <label>Professor:</label>
    <select name="professor">
      <option value="">Todos</option>
      <?php
      $professores = $conn->query("SELECT id, nome FROM professores ORDER BY nome");
      while ($p = $professores->fetch_assoc()) {
          $sel = ($_GET['professor'] ?? '') == $p['id'] ? 'selected' : '';
          echo "<option value='{$p['id']}' $sel>".htmlspecialchars($p['nome'])."</option>";
      }
      ?>
    </select>

    <label>Data Inicial:</label>
    <input type="date" name="data_inicio" value="<?= htmlspecialchars($_GET['data_inicio'] ?? '') ?>">

    <label>Data Final:</label>
    <input type="date" name="data_fim" value="<?= htmlspecialchars($_GET['data_fim'] ?? '') ?>">

    <button type="submit">Filtrar</button>
  </form>

  <table>
    <thead>
      <tr>
        <th>Professor</th>
        <th>Data</th>
        <th>Hora Entrada</th>
        <th>Hora Saída</th>
        <th>Observações</th>
        <th>Ações</th>
      </tr>
    </thead>
    <tbody>
      <?php
      $where = [];

      // Filtro por professor
      if (!empty($_GET['professor'])) {
          $prof_id = (int)$_GET['professor'];
          $where[] = "p.id_professor = $prof_id";
      }

      // Filtro por período
      if (!empty($_GET['data_inicio']) && !empty($_GET['data_fim'])) {
          $data_inicio = $conn->real_escape_string($_GET['data_inicio']);
          $data_fim = $conn->real_escape_string($_GET['data_fim']);
          $where[] = "p.data_ponto BETWEEN '$data_inicio' AND '$data_fim'";
      } else {
          // Mês atual padrão
          $data_inicio = date('Y-m-01');
          $data_fim = date('Y-m-t');
          $where[] = "p.data_ponto BETWEEN '$data_inicio' AND '$data_fim'";
      }

      $sql = "SELECT p.*, f.nome FROM ponto p 
              JOIN professores f ON f.id = p.id_professor";
      if ($where) $sql .= " WHERE " . implode(" AND ", $where);
      $sql .= " ORDER BY p.data_ponto DESC";

      $res = $conn->query($sql);

      if (!$res) {
          echo "<tr><td colspan='6'>Erro na consulta: " . htmlspecialchars($conn->error) . "</td></tr>";
      } else {
          if ($res->num_rows > 0) {
              while ($row = $res->fetch_assoc()) {
                  $linkEditar = "editar_ponto.php?id={$row['id']}";
                  $linkExcluir = "excluir_ponto.php?id={$row['id']}";
                  $linkCalcular = "calcular_ponto.php?professor_id={$row['id_professor']}&data_inicio={$data_inicio}&data_fim={$data_fim}";

                  echo "<tr>
                          <td>".htmlspecialchars($row['nome'])."</td>
                          <td>{$row['data_ponto']}</td>
                          <td>{$row['hora_entrada']}</td>
                          <td>{$row['hora_saida']}</td>
                          <td>".htmlspecialchars($row['observacoes'])."</td>
                          <td class='acoes'>
                              <a class='editar' href='$linkEditar'>Editar</a>
                              <a class='excluir' href='$linkExcluir' onclick='return confirm(\"Deseja realmente excluir?\")'>Excluir</a>
                              <a class='calcular' href='$linkCalcular' target='_blank'>Calcular Horas</a>
                          </td>
                        </tr>";
              }
          } else {
              echo "<tr><td colspan='6'>Nenhum ponto encontrado.</td></tr>";
          }
      }
      ?>
    </tbody>
  </table>
</div>
</body>
</html>
