<?php
// =================================================================
// BLOCO DE INÍCIO PADRÃO
// =================================================================
include 'verifica_login.php';
include 'conexao.php';
$id_escola = $_SESSION['id_escola'];
$nome_usuario = $_SESSION['usuario_nome'];
$nivel_usuario = $_SESSION['usuario_nivel'];
// =================================================================

// --- BUSCA SEGURA COM JOIN PARA PEGAR O NOME DA ÁREA ---
$sql = "SELECT 
            c.id, 
            c.nome, 
            c.horas_total,
            a.nome AS area_nome 
        FROM 
            cursos c 
        LEFT JOIN 
            areas_curso a ON c.area_curso_id = a.id
        WHERE 
            c.id_escola = ? 
        ORDER BY c.nome ASC";

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $id_escola);
$stmt->execute();
$result = $stmt->get_result();
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8">
<title>Lista de Cursos</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<style>
/* Estilo 'Dashboard' Padrão */
:root {
    --bg: #f6f8fb; --card: #fff; --muted: #64748b; --text: #0f172a;
    --accent: #4f46e5; --ok: #10b981; --bad: #ef4444; --border: #e5e7eb;
}
* { box-sizing: border-box; }
body { font-family: Inter, Segoe UI, Roboto, Arial, sans-serif; background: var(--bg); color: var(--text); margin: 0; }
.container { max-width: 1000px; margin: 24px auto; padding: 16px; }
h1 { font-size: 22px; margin: 0; }
.card { background: var(--card); border: 1px solid var(--border); border-radius: 14px; padding: 20px; box-shadow: 0 10px 30px rgba(15,23,42,.04); }
.header-actions { display: flex; justify-content: space-between; align-items: center; margin-bottom: 16px; }
.btn { border: none; border-radius: 10px; padding: 12px 20px; cursor: pointer; font-weight: 600; font-size: 14px; text-decoration: none; display: inline-block; text-align: center; }
.btn.primary { background: var(--accent); color: #fff; }
/* Tabela */
table { width: 100%; border-collapse: collapse; margin-top: 10px; }
th, td { padding: 12px 16px; text-align: left; border-bottom: 1px solid var(--border); }
th { font-size: 12px; color: var(--muted); text-transform: uppercase; }
td { color: #334155; }
.actions-cell a { margin-right: 10px; font-size: 13px; text-decoration: none; color: var(--accent); font-weight: 500; }
.actions-cell a.delete { color: var(--bad); }
.total-count { margin-top: 16px; font-weight: 500; color: var(--muted); }
</style>
</head>
<body>
<div class="app-container">
    <?php include 'menu.php'; // Nosso menu lateral ?>

    <main class="main-content">
        <div class="header-actions" style="display: flex; gap: 10px; justify-content: space-between; align-items: center;">
            <br></br>
            <br></br>
            <br></br>
            <br></br>
            <h1>Lista de Cursos</h1>
            <div>
                <a class="btn secondary" href="areas_curso.php">Gerenciar Áreas</a>
                <a class="btn primary" href="adicionar_curso.php">+ Novo Curso</a>
            </div>
        </div>
        <div class="card">
            <table>
                <thead>
                    <tr>
                        <th>Nome do Curso</th>
                        <th>Área</th>
                        <th>Carga Horária</th>
                        <th>Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($result && $result->num_rows > 0): ?>
                        <?php while ($curso = $result->fetch_assoc()): ?>
                            <tr>
                                <td><?= htmlspecialchars($curso['nome']) ?></td>
                                <td><?= htmlspecialchars($curso['area_nome'] ?? 'N/A') ?></td>
                                <td><?= number_format($curso['horas_total'], 1, ',', '.') ?>h</td>
                                <td class="actions-cell">
                                    <a href="editar_curso.php?id=<?= $curso['id'] ?>">Editar</a>
                                    <a href="excluir_curso.php?id=<?= $curso['id'] ?>" class="delete" onclick="return confirm('Tem certeza que deseja excluir o curso \'<?= htmlspecialchars($curso['nome']) ?>\'?')">Excluir</a>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="4">Nenhum curso cadastrado ainda.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
            <?php if ($result): ?>
                <div class="total-count">
                    Total de cursos: <?= $result->num_rows ?>
                </div>
            <?php endif; ?>
        </div>

    </main>

    <?php include 'footer.php'; ?>
</div>
</body>
</html>