<?php
// Lógica para determinar a página ativa
$current_page = basename($_SERVER['SCRIPT_NAME']);

// Função auxiliar para checar se um link ou um grupo de links está ativo
function is_active($page_names) {
    global $current_page;
    if (is_array($page_names)) {
        return in_array($current_page, $page_names);
    }
    return $current_page == $page_names;
}

// Define quais páginas pertencem a cada grupo de menu
$instrutores_pages = ['professores.php', 'cadastro_professor.php', 'editar_professor.php'];
$ponto_pages = ['ponto.php', 'calcular_horas.php', 'editar_ponto.php'];
$cancelamentos_pages = ['listar_cancelamento.php', 'cancelamento_novo.php', 'editar_cancelamento.php'];
$cursos_pages = ['listar_cursos.php', 'adicionar_curso.php', 'editar_curso.php'];
?>
<style>
/* Reset básico e fontes */
:root {
    --sidebar-bg: #1f2937;
    --sidebar-text: #d1d5db;
    --sidebar-hover-bg: #374151;
    --sidebar-active-bg: #4f46e5;
    --sidebar-active-text: #ffffff;
    --main-bg: #f9fafb;
    --border-color: #374151;
}

body {
    margin: 0;
    font-family: Inter, Segoe UI, Roboto, Arial, sans-serif;
    background-color: var(--main-bg);
}

/* Estrutura principal com sidebar */
.app-container {
    display: flex;
}

.sidebar {
    width: 260px;
    background-color: var(--sidebar-bg);
    color: var(--sidebar-text);
    height: 100vh;
    position: fixed;
    top: 0;
    left: 0;
    display: flex;
    flex-direction: column;
    transition: transform 0.3s ease;
}

.main-content {
    margin-left: 260px;
    width: calc(100% - 260px);
    padding: 24px;
    transition: margin-left 0.3s ease, width 0.3s ease;
}

/* Cabeçalho do Sidebar */
.sidebar-header {
    padding: 20px;
    display: flex;
    align-items: center;
    border-bottom: 1px solid var(--border-color);
}
.sidebar-header .logo {
    font-size: 24px;
    font-weight: 700;
    background-color: var(--sidebar-active-bg);
    color: var(--sidebar-active-text);
    border-radius: 8px;
    padding: 8px 12px;
    margin-right: 12px;
}
.sidebar-header .title {
    font-size: 18px;
    font-weight: 600;
}

/* Navegação */
.sidebar-nav {
    flex-grow: 1;
    overflow-y: auto;
    padding: 16px 0;
}

.nav-item > a, .nav-item > button {
    display: flex;
    align-items: center;
    width: 100%;
    padding: 12px 20px;
    color: var(--sidebar-text);
    text-decoration: none;
    font-size: 15px;
    font-weight: 500;
    border: none;
    background: none;
    cursor: pointer;
    text-align: left;
    transition: background-color 0.2s ease, color 0.2s ease;
}

.nav-item > a:hover, .nav-item > button:hover {
    background-color: var(--sidebar-hover-bg);
}

.nav-item.active > a, .nav-item.active > button {
    background-color: var(--sidebar-active-bg);
    color: var(--sidebar-active-text);
    border-radius: 6px;
    margin: 0 8px;
    padding: 12px;
}
/* Ajusta o padding para o item ativo não saltar */
.nav-item.active > a, .nav-item.active > button { padding: 12px 20px; margin: 0; border-radius: 0; }
.nav-item.active-group > button {
    background-color: var(--sidebar-hover-bg);
}


/* Submenu */
.submenu {
    max-height: 0;
    overflow: hidden;
    transition: max-height 0.3s ease-out;
    background-color: rgba(0,0,0,0.2);
}
.nav-item.open > .submenu {
    max-height: 500px; /* Altura suficiente para os links */
}
.submenu a {
    display: block;
    padding: 10px 20px 10px 40px; /* Indentação */
    color: var(--sidebar-text);
    text-decoration: none;
    font-size: 14px;
}
.submenu a:hover {
    background-color: var(--sidebar-hover-bg);
}
.submenu a.active {
    font-weight: 700;
    color: var(--sidebar-active-text);
}

/* Responsivo */
.menu-toggle { display: none; }
@media (max-width: 900px) {
    .sidebar { transform: translateX(-260px); z-index: 1000; }
    .main-content { margin-left: 0; width: 100%; }
    body.menu-open .sidebar { transform: translateX(0); }
    .menu-toggle {
        display: block;
        position: fixed;
        top: 15px;
        left: 15px;
        z-index: 1001;
        background: #fff;
        border: 1px solid #ccc;
        border-radius: 8px;
        padding: 8px 12px;
        cursor: pointer;
    }
}
</style>

<aside class="sidebar">
    <div class="sidebar-header">
        <span class="logo">IM</span>
        <span class="title">Administração</span>
    </div>

    <nav class="sidebar-nav">
        <div class="nav-item <?php if (is_active('index.php')) echo 'active'; ?>">
            <a href="index.php">Dashboard</a>
        </div>
        
        <div class="nav-item <?php if (is_active($instrutores_pages)) echo 'open active-group'; ?>">
            <button onclick="this.parentElement.classList.toggle('open')">Instrutores</button>
            <div class="submenu">
                <a href="professores.php" class="<?php if (is_active('professores.php')) echo 'active'; ?>">Listar Instrutores</a>
                <a href="cadastro_professor.php" class="<?php if (is_active('cadastro_professor.php')) echo 'active'; ?>">Novo Instrutor</a>
            </div>
        </div>
        
        <div class="nav-item <?php if (is_active($cursos_pages)) echo 'open active-group'; ?>">
            <button onclick="this.parentElement.classList.toggle('open')">Cursos</button>
            <div class="submenu">
                <a href="listar_cursos.php" class="<?php if (is_active('listar_cursos.php')) echo 'active'; ?>">Listar Cursos</a>
                <a href="adicionar_curso.php" class="<?php if (is_active('adicionar_curso.php')) echo 'active'; ?>">Novo Curso</a>
            </div>
        </div>

        <div class="nav-item <?php if (is_active($ponto_pages)) echo 'open active-group'; ?>">
            <button onclick="this.parentElement.classList.toggle('open')">Ponto</button>
            <div class="submenu">
                <a href="ponto.php" class="<?php if (is_active('ponto.php')) echo 'active'; ?>">Registrar Ponto</a>
                <a href="calcular_horas.php" class="<?php if (is_active('calcular_horas.php')) echo 'active'; ?>">Relatório de Horas</a>
            </div>
        </div>

        <div class="nav-item <?php if (is_active($cancelamentos_pages)) echo 'open active-group'; ?>">
            <button onclick="this.parentElement.classList.toggle('open')">Cancelamentos</button>
            <div class="submenu">
                <a href="listar_cancelamento.php" class="<?php if (is_active('listar_cancelamento.php')) echo 'active'; ?>">Listar Cancelamentos</a>
                <a href="cancelamento_novo.php" class="<?php if (is_active('cancelamento_novo.php')) echo 'active'; ?>">Novo Cancelamento</a>
            </div>
        </div>
        <div class="nav-item <?php if (is_active($Tarefas)) echo 'open active-group'; ?>">
            <button onclick="this.parentElement.classList.toggle('open')">Tarefas</button>
            <div class="submenu">
                <a href="tarefas.php" class="<?php if (is_active('tarefas.php')) echo 'active'; ?>">Tarefas</a>
            </div>
        </div>        
    </nav>
</aside>

<button class="menu-toggle" onclick="document.body.classList.toggle('menu-open')">☰ Menu</button>

<script>
// Mantém aberto o submenu da página ativa ao carregar a página
document.addEventListener("DOMContentLoaded", function() {
    // A lógica de abrir o menu ativo já está no PHP, com a classe 'open'
});
</script>