<?php
// MOSTRAR ERROS (exceto avisos de "deprecated", que já sabemos que existem)
error_reporting(E_ALL & ~E_DEPRECATED);
ini_set('display_errors', 1);

// PASSO 1: LIDAR COM A SESSÃO E A BASE DE DADOS
include 'verifica_login.php';
include 'conexao.php';

// ... (toda a lógica para buscar dados do professor e do modelo, que já está correta) ...
$id_escola = $_SESSION['id_escola'];
$id_professor = (int)($_GET['id_prof'] ?? 0);
$id_modelo = (int)($_GET['id_modelo'] ?? 0);

if ($id_professor <= 0 || $id_modelo <= 0) {
    die("ID do professor ou do modelo de contrato inválido.");
}

$sql_prof = "SELECT 
                p.nome AS prof_nome, p.estado_civil AS prof_estado_civil, p.rg AS prof_rg, p.cpf AS prof_cpf, 
                p.endereco AS prof_endereco, p.valor_hora_aula, p.data_admissao,
                e.nome AS escola_nome, e.cnpj AS escola_cnpj, e.endereco_completo AS escola_endereco, 
                e.representante AS escola_representante, e.rg_representante AS escola_rg_rep, e.cpf_representante AS escola_cpf_rep,
                e.cidade AS escola_cidade
            FROM professores p
            JOIN escolas e ON p.id_escola = e.id
            WHERE p.id = ? AND p.id_escola = ?";
            
$stmt_prof = $conn->prepare($sql_prof);
$stmt_prof->bind_param("ii", $id_professor, $id_escola);
$stmt_prof->execute();
$result_prof = $stmt_prof->get_result();
if ($result_prof->num_rows !== 1) {
    die("Erro crítico: A consulta do professor retornou " . $result_prof->num_rows . " linhas.");
}
$dados_prof_escola = $result_prof->fetch_assoc();

$sql_modelo = "SELECT conteudo FROM modelos_contrato WHERE id = ?";
$stmt_modelo = $conn->prepare($sql_modelo);
$stmt_modelo->bind_param("i", $id_modelo);
$stmt_modelo->execute();
$modelo = $stmt_modelo->get_result()->fetch_assoc();
if (!$modelo) {
    die("Modelo de contrato não encontrado.");
}
$conn->close();

// =================================================================
// PASSO 2: PREPARAÇÃO DOS DADOS E GERAÇÃO DO PDF
// =================================================================
require('fpdf.php');

// --- CORREÇÃO DA DATA ---
// Usando a classe IntlDateFormatter, que é a forma moderna e correta.
$formatter = new IntlDateFormatter(
    'pt_BR',
    IntlDateFormatter::LONG, // Formato: 21 de setembro de 2025
    IntlDateFormatter::NONE
);
$data_inicio_formatada = $formatter->format(strtotime($dados_prof_escola['data_admissao']));
$data_termino_formatada = $formatter->format(strtotime("+1 year", strtotime($dados_prof_escola['data_admissao'])));
// --- FIM DA CORREÇÃO ---

$placeholders = [
    '[NOME_PROFESSOR]'          => $dados_prof_escola['prof_nome'],
    '[ESTADO_CIVIL_PROFESSOR]'  => $dados_prof_escola['prof_estado_civil'],
    '[RG_PROFESSOR]'            => $dados_prof_escola['prof_rg'],
    '[CPF_PROFESSOR]'           => $dados_prof_escola['prof_cpf'],
    '[ENDERECO_PROFESSOR]'      => $dados_prof_escola['prof_endereco'],
    '[VALOR_HORA_AULA]'         => 'R$ ' . number_format($dados_prof_escola['valor_hora_aula'], 2, ',', '.'),
    '[DATA_INICIO_CONTRATO]'    => $data_inicio_formatada,
    '[DATA_TERMINO_CONTRATO]'   => $data_termino_formatada,
    '[NOME_CONTRATANTE]'        => $dados_prof_escola['escola_nome'],
    '[CNPJ_CONTRATANTE]'        => $dados_prof_escola['escola_cnpj'],
    '[ENDERECO_CONTRATANTE]'    => $dados_prof_escola['escola_endereco'],
    '[NOME_REPRESENTANTE]'      => $dados_prof_escola['escola_representante'],
    '[RG_REPRESENTANTE]'        => $dados_prof_escola['escola_rg_rep'],
    '[CPF_REPRESENTANTE]'       => $dados_prof_escola['escola_cpf_rep'],
    '[CIDADE_ESCOLA]'           => $dados_prof_escola['escola_cidade']
];

$texto_contrato = $modelo['conteudo'];
$texto_final = str_replace(array_keys($placeholders), array_values($placeholders), $texto_contrato);

class PDF extends FPDF {
    function Header() {
        if (file_exists('logo.png')) $this->Image('logo.png', 10, 6, 40);
        $this->SetFont('Arial', 'B', 12);
        $this->Cell(0, 10, utf8_decode('CONTRATO PARTICULAR DE PRESTAÇÃO DE SERVIÇOS DE TRABALHO AUTÔNOMO'), 0, 1, 'C');
        $this->Ln(5);
    }
    function Footer() {
        $this->SetY(-15);
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(0, 5, utf8_decode('Data de emissão: ' . date('d/m/Y')), 0, 1, 'L');
        $this->Cell(0, 5, utf8_decode('Página ') . $this->PageNo() . '/{nb}', 0, 0, 'R');
    }
}

if (ob_get_length()) ob_end_clean();

$pdf = new PDF();
$pdf->AliasNbPages();
$pdf->AddPage();
$pdf->SetFont('Arial', '', 11);
$pdf->MultiCell(0, 6, utf8_decode($texto_final));
$pdf->Output("I", "Contrato-" . preg_replace('/[^A-Za-z0-9\-]/', '', $dados_prof_escola['prof_nome']) . ".pdf");
exit;
?>