http://www.fpdf.org/en/dl.php?v=186&f=zip<?php
require('fpdf/fpdf.php');
include 'conexao.php';

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    die("ID inválido.");
}

$id = (int)$_GET['id'];

// Buscar dados do professor
$stmt = $conn->prepare("SELECT nome, estado_civil, rg, cpf, endereco, valor_hora_aula, data_admissao FROM professores WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    die("Professor não encontrado.");
}

$prof = $result->fetch_assoc();

// Dados fixos da contratante
$contratante_nome = "M&K CURSOS E TREINAMENTOS LTDA";
$contratante_cnpj = "47.749.272/0001-52";
$contratante_endereco = "AV. PRESIDENTE GETULIO VARGAS, 4281, BAIRRO MAIRA REGINA, ALVORADA, CEP 94818-001";
$contratante_representante = "Ketilin Da Silva";
$contratante_rg = "4085807909";
$contratante_cpf = "003.138.570-24";

// Datas
$data_inicio = date("d \d\e F \d\e Y", strtotime($prof['data_admissao']));
$data_termino = date("d \d\e F \d\e Y", strtotime("+1 year", strtotime($prof['data_admissao'])));

// Valor hora aula formatado
$valor_hora_aula = "R$ " . number_format($prof['valor_hora_aula'], 2, ',', '.');

// Classe PDF com cabeçalho e rodapé
class PDF extends FPDF
{
    function Header()
    {
        // Logo no canto esquerdo
        $this->Image('Logo Instituto Mix - Vermelho.png', 10, 6, 40);
        $this->SetFont('Arial', 'B', 12);
        $this->Cell(0, 10, utf8_decode('CONTRATO PARTICULAR DE PRESTAÇÃO DE SERVIÇOS DE TRABALHO AUTÔNOMO'), 0, 1, 'C');
        $this->Ln(5);
    }

    function Footer()
    {
        $this->SetY(-15);
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(0, 5, utf8_decode('Data de emissão: ' . date('d/m/Y')), 0, 1, 'L');
        $this->Cell(0, 5, utf8_decode('Página ') . $this->PageNo() . '/{nb}', 0, 0, 'R');
    }

    function ChapterBody($txt)
    {
        $this->SetFont('Arial', '', 11);
        $this->MultiCell(0, 6, utf8_decode($txt));
        $this->Ln();
    }
}

$pdf = new PDF();
$pdf->AliasNbPages();
$pdf->AddPage();

// Texto do contrato
$texto = "
Pelo presente Instrumento Particular de Contrato de Prestação de Trabalho Autônomo, de um lado {$contratante_nome} devidamente inscrita no CNPJ nº {$contratante_cnpj}, situada na {$contratante_endereco}, neste ato devidamente representado por sua sócia proprietária, {$contratante_representante}, brasileira, casada, Administrador de Empresas, RG {$contratante_rg} e CPF {$contratante_cpf} doravante denominado CONTRATANTE, e de outro lado, {$prof['nome']}, {$prof['estado_civil']}, RG Nº {$prof['rg']} CPF Nº {$prof['cpf']} com endereço em {$prof['endereco']}, neste ato doravante denominado de CONTRATADO, têm entre si justo e contratado o presente contrato mediante as cláusulas e condições seguintes, que mutuamente prometem cumprir e respeitar, a saber:

CLÁUSULA PRIMEIRA – O presente contrato tem como objetivo a prestação de serviços de trabalho autônomo por parte do CONTRATADO, e mais as funções que vierem a ser objeto de solicitações verbais ou por escrito, seguindo as necessidades da CONTRATANTE, desde que compatíveis com as atribuições da modalidade de especialização do CONTRATADO.

CLÁUSULA SEGUNDA – Os serviços ora contratados terão sua realização junto às dependências da CONTRATANTE, podendo, contudo, a CONTRATANTE transferir o CONTRATADO para outra localidade, quer a título temporário, quer a título definitivo, da qual o CONTRATADO expressa sua concordância.

CLÁUSULA TERCEIRA – O horário a ser cumprido pelo CONTRATADO poderá ser nos períodos da manhã, tarde ou noite, sempre condicionado ao preenchimento de controle de horas.

CLÁUSULA QUARTA – O presente Contrato terá sua validade por prazo de um ano, tendo seu início em {$data_inicio} e término em {$data_termino}, ficando facultado às partes a rescisão do presente contrato, sem qualquer multa, desde que previamente avisada a parte contrária com antecedência mínima de 30 dias, ocasião em que o CONTRATADO receberá pelos seus serviços prestados nos moldes do quanto convencionado na cláusula quinta do presente contrato. Em caso de descumprimento do período de 30 dias, deverá qualquer uma das partes efetuar o pagamento à outra do valor referente às horas que seriam ministradas durante esse período.

CLÁUSULA QUINTA – Será solicitado ao CONTRATADO, eventualmente, um treinamento, que consiste em apresentar para a equipe comercial da CONTRATANTE o conteúdo tratado no curso o qual ele é titular. Este treinamento não é remunerado.

PARÁGRAFO ÚNICO – Esclarecem as partes que o presente contrato é realizado sem vínculo empregatício.

CLÁUSULA SEXTA – Em contraprestação dos serviços, o CONTRATANTE pagará ao CONTRATADO o valor de {$valor_hora_aula} por hora aula, pago no dia 10 de cada mês subsequente à prestação do serviço e mediante apresentação de RPA ou Nota Fiscal por parte do CONTRATADO.

CLÁUSULA SÉTIMA – Este contrato obriga as partes contratantes por si e seus sucessores.

CLÁUSULA OITAVA – As partes elegem o foro da comarca de Alvorada, RS, para dirimir eventuais dúvidas decorrentes do presente.

E, por estarem assim justos e contratados, assinam o presente instrumento em duas vias de igual teor e forma, na presença de duas testemunhas.

Alvorada, _____ de _________________________ de _____.


CONTRATANTE: ______________________________________
{$contratante_nome}

CONTRATADO: ______________________________________
{$prof['nome']}


Testemunhas:
1. _______________________________________________
2. _______________________________________________
";

$pdf->ChapterBody($texto);
$pdf->Output("I", "Contrato_Professor_{$prof['nome']}.pdf");
