<style>
    /* Estilos para o rodapé */
    .app-footer {
        position: fixed;
        bottom: 0;
        left: 260px; /* Mesma largura do menu lateral */
        width: calc(100% - 260px);
        background-color: #ffffff;
        border-top: 1px solid #e5e7eb;
        padding: 8px 20px;
        font-size: 12px;
        color: #64748b;
        display: flex;
        justify-content: space-between;
        align-items: center;
        z-index: 999;
        transition: left 0.3s ease, width 0.3s ease;
    }

    .footer-user, .footer-datetime {
        font-weight: 500;
    }

    /* Ajuste para telas pequenas quando o menu some */
    @media (max-width: 900px) {
        .app-footer {
            left: 0;
            width: 100%;
        }
    }
</style>

<footer class="app-footer">
    <div class="footer-user">
        Usuário Logado: <strong><?= isset($_SESSION['usuario_nome']) ? htmlspecialchars($_SESSION['usuario_nome']) : 'N/A' ?></strong>
    </div>
    <div class="footer-datetime" id="datetime-display">
        Carregando...
    </div>
</footer>

<script>
    // Script para o relógio dinâmico
    function updateDateTime() {
        const now = new Date();
        const optionsDate = { day: '2-digit', month: '2-digit', year: 'numeric' };
        const optionsTime = { hour: '2-digit', minute: '2-digit', second: '2-digit' };
        
        const dateString = now.toLocaleDateString('pt-BR', optionsDate);
        const timeString = now.toLocaleTimeString('pt-BR', optionsTime);

        const dateTimeString = `${dateString} - ${timeString}`;
        
        const displayElement = document.getElementById('datetime-display');
        if (displayElement) {
            displayElement.textContent = dateTimeString;
        }
    }

    // Atualiza o relógio a cada segundo
    setInterval(updateDateTime, 1000);

    // Chama a função uma vez no início para não esperar 1 segundo
    updateDateTime();
</script>