<?php
session_start();
include 'conexao.php';

// --- LÓGICA MULTI-ESCOLA E SEGURANÇA DE ACESSO ---
$id_escola = 1; // <--- Definição estática. Será trocado pelo login.

// 1. Validação do ID
$id_professor = $_GET['id'] ?? null;
if (!$id_professor || !is_numeric($id_professor)) {
    // Se o ID for inválido, redireciona de volta com uma mensagem de erro.
    header("Location: professores.php?msg=erro_id_invalido");
    exit;
}

// 2. Preparação da query de exclusão segura
// A query SÓ vai excluir se o ID do professor E o ID da escola baterem.
// Isso impede que um usuário da escola 1 apague um professor da escola 2.
$sql = "DELETE FROM professores WHERE id = ? AND id_escola = ?";
$stmt = $conn->prepare($sql);

if ($stmt) {
    $stmt->bind_param("ii", $id_professor, $id_escola);
    
    if ($stmt->execute()) {
        // Se a exclusão deu certo, redireciona para a lista.
        header("Location: professores.php?msg=excluido_sucesso");
        exit;
    }
}

// Se chegou até aqui, algo deu errado.
// Pode ser um erro no banco ou tentativa de exclusão de professor de outra escola.
header("Location: professores.php?msg=erro_excluir");
exit;

?>