<?php
include 'conexao.php';
include 'includes/menu.php';
$id = $_GET['id'] ?? 0;

if ($id == 0) {
    die("ID inválido.");
}

// Confirmar exclusão
if (isset($_POST['confirmar'])) {
    $stmt = $conn->prepare("DELETE FROM cancelamentos WHERE id = ?");
    $stmt->bind_param("i", $id);

    if ($stmt->execute()) {
        header("Location: listar_cancelamento.php");
        exit;
    } else {
        echo "Erro ao excluir: " . $stmt->error;
    }
}

// Buscar registro para exibir nome antes de excluir
$stmt = $conn->prepare("SELECT aluno_nome FROM cancelamentos WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$cancelamento = $result->fetch_assoc();

if (!$cancelamento) {
    die("Registro não encontrado.");
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8">
<title>Excluir Cancelamento</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<style>
body { font-family: Arial, sans-serif; background: #f8fafc; margin: 0; }
.container { max-width: 500px; margin: 60px auto; background: #fff; padding: 20px; border-radius: 8px; box-shadow: 0 4px 10px rgba(0,0,0,0.05); text-align: center; }
h1 { font-size: 18px; margin-bottom: 20px; }
button { padding: 10px 15px; border: none; border-radius: 5px; cursor: pointer; margin: 5px; }
.confirmar { background: #dc2626; color: white; }
.confirmar:hover { background: #b91c1c; }
.cancelar { background: #4b5563; color: white; }
.cancelar:hover { background: #374151; }
</style>
</head>
<body>
<div class="container">
    <h1>Tem certeza que deseja excluir o cancelamento de:</h1>
    <p><strong><?= htmlspecialchars($cancelamento['aluno_nome']) ?></strong></p>
    <form method="post">
        <button type="submit" name="confirmar" class="confirmar">Sim, excluir</button>
        <a href="listar_cancelamento.php"><button type="button" class="cancelar">Cancelar</button></a>
    </form>
</div>
</body>
</html>
