<?php
// =================================================================
// BLOCO DE INÍCIO PADRÃO
// =================================================================
include 'verifica_login.php';
include 'conexao.php';
$id_escola = $_SESSION['id_escola'];
$nome_usuario = $_SESSION['usuario_nome'];
$nivel_usuario = $_SESSION['usuario_nivel'];
// =================================================================

$id_professor = $_GET['id'] ?? null;

if (!$id_professor || !is_numeric($id_professor)) {
    die("ID do professor inválido.");
}

// BUSCAR DADOS DO PROFESSOR (APENAS SE PERTENCER À ESCOLA CORRETA)
$stmt = $conn->prepare("SELECT * FROM professores WHERE id = ? AND id_escola = ?");
$stmt->bind_param("ii", $id_professor, $id_escola);
$stmt->execute();
$result = $stmt->get_result();
$professor = $result->fetch_assoc();

if (!$professor) {
    die("Professor não encontrado ou não pertence à sua escola.");
}

$mensagem_erro = '';

// ATUALIZAR DADOS
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // A lógica do POST já estava correta e segura, então a mantemos.
    $nome = $_POST['nome'] ?? '';
    // ... (e as outras variáveis do POST) ...
    $cpf = $_POST['cpf'] ?? '';
    $rg = $_POST['rg'] ?? '';
    $telefone = $_POST['telefone'] ?? '';
    $nome_curso = $_POST['nome_curso'] ?? '';
    $area_curso = $_POST['area_curso'] ?? '';
    $pix = $_POST['pix'] ?? '';
    $banco = $_POST['banco'] ?? '';
    $observacoes = $_POST['observacoes'] ?? '';
    $data_admissao = $_POST['data_admissao'] ?: null;
    $data_demissao = $_POST['data_demissao'] ?: null;
    $ajuda_custo = $_POST['ajuda_custo'] ? (float)str_replace(',', '.', $_POST['ajuda_custo']) : 0.0;
    $valor_hora_aula = $_POST['valor_hora_aula'] ? (float)str_replace(',', '.', $_POST['valor_hora_aula']) : 0.0;
    $dia_pagamento = $_POST['dia_pagamento'] ?? '';
    $endereco = $_POST['endereco'] ?? '';
    $estado_civil = $_POST['estado_civil'] ?? '';

    $sql = "UPDATE professores SET nome=?, cpf=?, rg=?, telefone=?, nome_curso=?, area_curso=?, pix=?, banco=?, observacoes=?, data_admissao=?, data_demissao=?, ajuda_custo=?, valor_hora_aula=?, dia_pagamento=?, endereco=?, estado_civil=? WHERE id = ? AND id_escola = ?";
    
    $stmt_update = $conn->prepare($sql);
    
    $stmt_update->bind_param("sssssssssssddsssii", $nome, $cpf, $rg, $telefone, $nome_curso, $area_curso, $pix, $banco, $observacoes, $data_admissao, $data_demissao, $ajuda_custo, $valor_hora_aula, $dia_pagamento, $endereco, $estado_civil, $id_professor, $id_escola);

    if ($stmt_update->execute()) {
        header("Location: professores.php?msg=sucesso");
        exit;
    } else {
        $mensagem_erro = "Erro ao atualizar o professor: " . $stmt_update->error;
    }
}

// CORREÇÃO: Buscar cursos e suas áreas com JOIN
$cursos_result = $conn->query("SELECT c.nome, a.nome AS area_nome FROM cursos c JOIN areas_curso a ON c.area_curso_id = a.id WHERE c.id_escola = $id_escola ORDER BY c.nome ASC");
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8">
<title>Editar Professor - <?= htmlspecialchars($professor['nome']) ?></title>
<meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
/* Estilo 'Dashboard' inspirado nos seus outros arquivos */
:root {
    --bg: #f6f8fb; --card: #fff; --muted: #64748b; --text: #0f172a;
    --accent: #4f46e5; --ok: #10b981; --bad: #ef4444; --border: #e5e7eb;
}
* { box-sizing: border-box; }
body { font-family: Inter, Segoe UI, Roboto, Arial, sans-serif; background: var(--bg); color: var(--text); margin: 0; }
.container { max-width: 980px; margin: 24px auto; padding: 16px; }
h1 { font-size: 22px; margin: 0 0 12px; }
.card { background: var(--card); border: 1px solid var(--border); border-radius: 14px; padding: 20px; box-shadow: 0 10px 30px rgba(15,23,42,.04); margin-bottom: 14px; }
.grid { display: grid; grid-template-columns: repeat(12, 1fr); gap: 16px; }
.col-12 { grid-column: span 12; } .col-6 { grid-column: span 6; } .col-4 { grid-column: span 4; }
label { font-size: 13px; color: var(--muted); display: block; margin-bottom: 6px; font-weight: 500; }
input, select, textarea { width: 100%; padding: 10px 12px; border: 1px solid var(--border); border-radius: 10px; font-size: 14px; background: #fff; }
textarea { min-height: 80px; }
.btn { border: none; border-radius: 10px; padding: 12px 20px; cursor: pointer; font-weight: 600; font-size: 14px; }
.btn.primary { background: var(--accent); color: #fff; }
.msg { padding: 12px 16px; border-radius: 10px; margin-bottom: 16px; font-weight: 500; }
.msg.ok { background: #ecfdf5; color: #065f46; border: 1px solid #a7f3d0; }
.msg.err { background: #fef2f2; color: #991b1b; border: 1px solid #fecaca; }
@media (max-width: 760px) { .col-6, .col-4 { grid-column: span 12; } }
</style>
</head>
<body>

<div class="app-container">
    <?php include 'menu.php'; ?>

    <main class="main-content">
        <br></br>
         <br></br>
        <h1>Editar Instrutor: <?= htmlspecialchars($professor['nome']) ?></h1>
    
        <?php if ($mensagem_erro): ?><div class="msg err"><?= htmlspecialchars($mensagem_erro) ?></div><?php endif; ?>

        <form method="post">
            <div class="card">
                <div class="grid">
                    <div class="col-12"><label>Nome Completo</label><input type="text" name="nome" value="<?= htmlspecialchars($professor['nome']) ?>" required></div>
                    <div class="col-4"><label>CPF</label><input type="text" name="cpf" value="<?= htmlspecialchars($professor['cpf']) ?>"></div>
                    <div class="col-4"><label>RG</label><input type="text" name="rg" value="<?= htmlspecialchars($professor['rg']) ?>"></div>
                    <div class="col-4"><label>Estado Civil</label><input type="text" name="estado_civil" value="<?= htmlspecialchars($professor['estado_civil']) ?>"></div>
                    <div class="col-6"><label>Telefone</label><input type="text" name="telefone" value="<?= htmlspecialchars($professor['telefone']) ?>"></div>
                    <div class="col-6"><label>Endereço</label><input type="text" name="endereco" value="<?= htmlspecialchars($professor['endereco']) ?>"></div>
                </div>
            </div>

            <div class="card">
                 <div class="grid">
                    <div class="col-6"><label>Curso Principal</label>
                        <select name="nome_curso" id="nome_curso" onchange="atualizarAreaCurso()" required>
                            <?php 
                            if($cursos_result) {
                                while($curso = $cursos_result->fetch_assoc()): 
                                    $selected = ($curso['nome'] == $professor['nome_curso']) ? 'selected' : '';
                            ?>
                                    <option value="<?= htmlspecialchars($curso['nome']) ?>" data-area="<?= htmlspecialchars($curso['area_nome']) ?>" <?= $selected ?>>
                                        <?= htmlspecialchars($curso['nome']) ?>
                                    </option>
                            <?php 
                                endwhile;
                                // Reinicia o ponteiro para usar os dados no futuro, se necessário
                                $cursos_result->data_seek(0);
                            }
                            ?>
                        </select>
                    </div>
                    <div class="col-6"><label>Área do Curso</label><input type="text" name="area_curso" id="area_curso" value="<?= htmlspecialchars($professor['area_curso']) ?>" readonly style="background:#eef2f7;"></div>
                    <div class="col-6"><label>Data de Admissão</label><input type="date" name="data_admissao" value="<?= htmlspecialchars($professor['data_admissao']) ?>"></div>
                    <div class="col-6"><label>Data de Demissão</label><input type="date" name="data_demissão" value="<?= htmlspecialchars($professor['data_demissao'] ?? '') ?>"></div>
                </div>
            </div>
            
            <div class="card">
                <div class="grid">
                    <div class="col-4"><label>Valor Hora/Aula (R$)</label><input type="text" inputmode="decimal" name="valor_hora_aula" value="<?= number_format((float)($professor['valor_hora_aula'] ?? 0), 2, ',', '.') ?>"></div>
                    <div class="col-4"><label>Ajuda de Custo (R$)</label><input type="text" inputmode="decimal" name="ajuda_custo" value="<?= number_format((float)($professor['ajuda_custo'] ?? 0), 2, ',', '.') ?>"></div>
                    <div class="col-4"><label>Dia de Pagamento</label><input type="text" name="dia_pagamento" value="<?= htmlspecialchars($professor['dia_pagamento'] ?? '') ?>"></div>
                    <div class="col-6"><label>PIX</label><input type="text" name="pix" value="<?= htmlspecialchars($professor['pix']) ?>"></div>
                    <div class="col-6"><label>Banco</label><input type="text" name="banco" value="<?= htmlspecialchars($professor['banco']) ?>"></div>
                </div>
            </div>

            <div class="card">
                <label>Observações</label>
                <textarea name="observacoes"><?= htmlspecialchars($professor['observacoes']) ?></textarea>
            </div>

            <div class="actions" style="text-align: right;">
                <a href="professores.php" class="btn ghost">Cancelar</a>
                <button type="submit" class="btn primary">Salvar Alterações</button>
            </div>
        </form>
         <br></br>
        <?php include 'footer.php'; ?>
    </main>
</div>

<script>
function atualizarAreaCurso() {
    const selectCurso = document.getElementById("nome_curso");
    if (selectCurso.selectedIndex >= 0) {
        const optionSelecionada = selectCurso.options[selectCurso.selectedIndex];
        const areaCurso = optionSelecionada.getAttribute("data-area");
        document.getElementById("area_curso").value = areaCurso || "";
    }
}
// Chama a função uma vez no carregamento para preencher a área do curso inicial
document.addEventListener("DOMContentLoaded", atualizarAreaCurso);
</script>

</body>
</html>