<?php
session_start();
include 'conexao.php';


// --- LÓGICA MULTI-ESCOLA E SEGURANÇA DE ACESSO ---
$id_escola = 1; // Definição estática. Será trocado pelo login.
$id_curso = $_GET['id'] ?? null;

if (!$id_curso || !is_numeric($id_curso)) {
    die("ID do curso inválido.");
}

// 1. BUSCAR DADOS DO CURSO (APENAS SE PERTENCER À ESCOLA CORRETA)
$stmt = $conn->prepare("SELECT nome, area_curso, horas_total FROM cursos WHERE id = ? AND id_escola = ?");
$stmt->bind_param("ii", $id_curso, $id_escola);
$stmt->execute();
$result = $stmt->get_result();
$curso = $result->fetch_assoc();

if (!$curso) {
    die("Curso não encontrado ou não pertence à sua escola.");
}

$mensagem_erro = '';

// 2. ATUALIZAR DADOS
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nome = $_POST['nome'] ?? '';
    $area_curso = $_POST['area_curso'] ?? '';
    $horas_total = $_POST['horas_total'] ? (float)str_replace(',', '.', $_POST['horas_total']) : 0.0;

    if (empty($nome) || empty($area_curso)) {
        $mensagem_erro = "O nome и a área do curso são obrigatórios.";
    } else {
        $sql = "UPDATE cursos SET nome = ?, area_curso = ?, horas_total = ? WHERE id = ? AND id_escola = ?";
        $stmt_update = $conn->prepare($sql);
        $stmt_update->bind_param("ssdii", $nome, $area_curso, $horas_total, $id_curso, $id_escola);

        if ($stmt_update->execute()) {
            header("Location: listar_cursos.php?msg=sucesso");
            exit;
        } else {
            $mensagem_erro = "Erro ao atualizar o curso: " . $stmt_update->error;
        }
    }
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8">
<title>Editar Curso</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<style>
/* Estilo 'Dashboard' Padrão */
:root {
    --bg: #f6f8fb; --card: #fff; --muted: #64748b; --text: #0f172a;
    --accent: #4f46e5; --ok: #10b981; --bad: #ef4444; --border: #e5e7eb;
}
* { box-sizing: border-box; }
body { font-family: Inter, Segoe UI, Roboto, Arial, sans-serif; background: var(--bg); color: var(--text); margin: 0; }
.container { max-width: 800px; margin: 24px auto; padding: 16px; }
h1 { font-size: 22px; margin: 0 0 12px; }
.card { background: var(--card); border: 1px solid var(--border); border-radius: 14px; padding: 20px; box-shadow: 0 10px 30px rgba(15,23,42,.04); }
.grid { display: grid; grid-template-columns: 1fr; gap: 16px; }
@media (min-width: 768px) { .grid { grid-template-columns: repeat(3, 1fr); } }
label { font-size: 13px; color: var(--muted); display: block; margin-bottom: 6px; font-weight: 500; }
input { width: 100%; padding: 10px 12px; border: 1px solid var(--border); border-radius: 10px; font-size: 14px; background: #fff; }
.btn { border: none; border-radius: 10px; padding: 12px 20px; cursor: pointer; font-weight: 600; font-size: 14px; text-decoration: none; }
.btn.primary { background: var(--accent); color: #fff; }
.btn.ghost { background: transparent; border: 1px solid var(--border); color: var(--text); }
.actions { display: flex; gap: 12px; justify-content: flex-end; margin-top: 20px; }
.msg.err { padding: 12px 16px; border-radius: 10px; margin-bottom: 16px; font-weight: 500; background: #fef2f2; color: #991b1b; border: 1px solid #fecaca; }
.full-width { grid-column: 1 / -1; }
</style>
</head>
<body>
        <div class="app-container">
        <?php include 'menu.php'; // Nosso menu lateral ?>

        <main class="main-content">
            </main>

        <?php include 'footer.php'; // <<-- ADICIONE ESTA LINHA AQUI ?>
    </div>
<div class="container">
    <h1>Editar Curso: <?= htmlspecialchars($curso['nome']) ?></h1>

    <?php if ($mensagem_erro): ?><div class="msg err"><?= htmlspecialchars($mensagem_erro) ?></div><?php endif; ?>

    <div class="card">
        <form method="post">
            <div class="grid">
                <div class="full-width">
                    <label for="nome">Nome do Curso</label>
                    <input type="text" id="nome" name="nome" value="<?= htmlspecialchars($curso['nome']) ?>" required>
                </div>

                <div>
                    <label for="area_curso">Área do Curso</label>
                    <input type="text" id="area_curso" name="area_curso" value="<?= htmlspecialchars($curso['area_curso']) ?>" required>
                </div>

                <div>
                    <label for="horas_total">Carga Horária Total</label>
                    <input type="text" id="horas_total" name="horas_total" inputmode="decimal" value="<?= number_format($curso['horas_total'], 1, ',', '.') ?>">
                </div>
            </div>

            <div class="actions">
                <a href="listar_cursos.php" class="btn ghost">Cancelar</a>
                <button type="submit" class="btn primary">Salvar Alterações</button>
            </div>
        </form>
    </div>
</div>
</body>
</html>