<?php
// =================================================================
// BLOCO DE INÍCIO PADRÃO
// =================================================================
include 'verifica_login.php';
include 'conexao.php';
$id_escola = $_SESSION['id_escola'];
$nome_usuario = $_SESSION['usuario_nome'];
$nivel_usuario = $_SESSION['usuario_nivel'];
// =================================================================

// PASSO 1: PEGAR O ID DA URL E VERIFICAR
$id_cancelamento = (int)($_GET['id'] ?? 0);
if ($id_cancelamento <= 0) {
    die("ID de cancelamento inválido.");
}

$mensagem_sucesso = '';
$mensagem_erro = '';

function br_to_float($v) {
    $v = trim((string)$v);
    if ($v === '') return 0.0;
    $v = str_replace('.', '', $v);
    $v = str_replace(',', '.', $v);
    return (float)$v;
}

// PASSO 2: LÓGICA DE ATUALIZAÇÃO (UPDATE)
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Coleta e recalcula os dados (mesma lógica do ficheiro de criação)
    $aluno_nome         = trim($_POST['aluno_nome'] ?? '');
    $curso_id           = (int)($_POST['curso_id'] ?? 0);
    $parcelas_contrato  = (int)($_POST['parcelas_contrato'] ?? 0);
    $valor_parcela      = br_to_float($_POST['valor_parcela'] ?? 0);
    $aulas_estudadas    = (int)($_POST['aulas_estudadas'] ?? 0);
    $duracao_aula       = br_to_float($_POST['duracao_aula'] ?? 0);
    $total_pago         = br_to_float($_POST['parcelas_pagas'] ?? 0); // Nome do campo no formulário antigo
    $percentual_multa   = br_to_float($_POST['percentual_multa'] ?? 10);
    $valor_total_curso_base = br_to_float($_POST['valor_total_curso'] ?? 0);
    $historico_conversa = trim($_POST['historico_conversa'] ?? '');
    
    $stmt_curso = $conn->prepare("SELECT horas_total FROM cursos WHERE id = ? AND id_escola = ?");
    $stmt_curso->bind_param("ii", $curso_id, $id_escola);
    $stmt_curso->execute();
    $curso_data = $stmt_curso->get_result()->fetch_assoc();
    $horas_total_curso = $curso_data['horas_total'] ?? 0;

    $valor_total_curso   = $parcelas_contrato * $valor_parcela;
    $valor_hora_aula     = ($horas_total_curso > 0) ? ($valor_total_curso_base / $horas_total_curso) : 0;
    $horas_estudadas     = $aulas_estudadas * $duracao_aula;
    $valor_estudado_sala = $horas_estudadas * $valor_hora_aula;
    $debito_credito      = $valor_estudado_sala - $total_pago;
    $valor_multa         = ($percentual_multa / 100.0) * $valor_total_curso_base;
    $valor_total_a_pagar = $debito_credito + $valor_multa;

    $sql = "UPDATE cancelamentos SET 
                aluno_nome = ?, curso_id = ?, parcelas_contrato = ?, valor_parcela = ?, valor_hora_aula = ?, 
                aulas_estudadas = ?, duracao_aula = ?, horas_estudadas = ?, valor_estudado_sala = ?, 
                parcelas_pagas = ?, valor_a_pagar_escola = ?, percentual_multa = ?, valor_total_curso = ?, 
                valor_multa = ?, valor_total_a_pagar = ?, historico_conversa = ?
            WHERE 
                id = ? AND id_escola = ?";
    
    $stmt = $conn->prepare($sql);
    
    $stmt->bind_param("siididdddddddddssii",
        $aluno_nome, $curso_id, $parcelas_contrato, $valor_parcela, $valor_hora_aula, $aulas_estudadas,
        $duracao_aula, $horas_estudadas, $valor_estudado_sala, $total_pago, $debito_credito,
        $percentual_multa, $valor_total_curso_base, $valor_multa, $valor_total_a_pagar, $historico_conversa,
        $id_cancelamento, $id_escola
    );

    if ($stmt->execute()) {
        header("Location: listar_cancelamento.php?msg=sucesso_edicao");
        exit;
    } else {
        $mensagem_erro = "Erro ao atualizar: " . $stmt->error;
    }
}

// PASSO 3: BUSCAR OS DADOS EXISTENTES PARA MOSTRAR NO FORMULÁRIO
$stmt_get = $conn->prepare("SELECT * FROM cancelamentos WHERE id = ? AND id_escola = ?");
$stmt_get->bind_param("ii", $id_cancelamento, $id_escola);
$stmt_get->execute();
$result_get = $stmt_get->get_result();
if ($result_get->num_rows !== 1) {
    die("Cancelamento não encontrado ou não pertence à sua escola.");
}
$cancelamento = $result_get->fetch_assoc();


// Buscar cursos da escola logada para o dropdown
$cursos_res = $conn->prepare("SELECT id, nome, horas_total FROM cursos WHERE id_escola = ? ORDER BY nome");
$cursos_res->bind_param("i", $id_escola);
$cursos_res->execute();
$cursos = $cursos_res->get_result();
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8">
<title>Editar Cancelamento</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="style.css">
<style>
    .calculator-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 20px; }
    .panel h2 { font-size: 16px; color: var(--accent-color); margin: 0 0 16px; padding-bottom: 8px; border-bottom: 2px solid var(--accent-color); }
    .input-group { display: grid; grid-template-columns: 1fr 1fr; gap: 16px; }
    .output-group { background-color: #f9fafb; padding: 12px; border-radius: 10px; margin-bottom: 16px; }
    .output-group h3 { font-size: 14px; margin: 0 0 8px; color: var(--muted-text); }
    .output-item { display: flex; justify-content: space-between; align-items: center; padding: 8px 0; border-bottom: 1px solid var(--border-color); }
    .output-item:last-child { border-bottom: none; }
    .output-item .label { font-size: 14px; color: var(--muted-text); position: relative; }
    .output-item .value { font-size: 16px; font-weight: 600; }
    .total-card .value { font-size: 28px; font-weight: 700; color: var(--danger-color); }
    .has-tooltip { cursor: help; border-bottom: 1px dotted #9ca3af; }
    .tooltip-text { visibility: hidden; width: 240px; background-color: #333; color: #fff; text-align: center; border-radius: 6px; padding: 8px; position: absolute; z-index: 1; bottom: 110%; left: 50%; transform: translateX(-50%); opacity: 0; transition: opacity 0.3s; font-size: 12px; }
    .has-tooltip:hover .tooltip-text { visibility: visible; opacity: 1; }
    @media (max-width: 900px) { .calculator-grid { grid-template-columns: 1fr; } }
</style>
</head>
<body>
<div class="app-container">
    <?php include 'menu.php'; ?>
    <main class="main-content">
        <h1>Editar Registo de Cancelamento</h1>
        <?php if ($mensagem_sucesso): ?><div class="msg ok"><?= htmlspecialchars($mensagem_sucesso) ?></div><?php endif; ?>
        <?php if ($mensagem_erro): ?><div class="msg err"><?= htmlspecialchars($mensagem_erro) ?></div><?php endif; ?>
        <form method="post" id="form-cancel">
            <div class="card">
                <h2>Dados do Aluno e Contrato</h2>
                <div class="grid col-4">
                    <div class="col-item col-span-2">
                        <label>Nome do Aluno</label>
                        <input type="text" name="aluno_nome" value="<?= htmlspecialchars($cancelamento['aluno_nome']) ?>" required>
                    </div>
                    <div>
                        <label>Nº Parcelas do Contrato</label>
                        <input type="number" name="parcelas_contrato" id="parcelas_contrato" value="<?= (int)$cancelamento['parcelas_contrato'] ?>" min="0">
                    </div>
                    <div>
                        <label>Valor da Parcela (R$)</label>
                        <input type="text" name="valor_parcela" id="valor_parcela" value="<?= number_format($cancelamento['valor_parcela'], 2, ',', '.') ?>" inputmode="decimal">
                    </div>
                </div>
            </div>
            <div class="card">
                <h2>Cálculo de Horas</h2>
                <div class="grid col-4">
                     <div class="col-item col-span-2">
                        <label>Curso</label>
                        <select name="curso_id" id="curso_id" required>
                            <option value="">Selecione...</option>
                            <?php while ($c = $cursos->fetch_assoc()): ?>
                                <?php $selected = ($c['id'] == $cancelamento['curso_id']) ? 'selected' : ''; ?>
                                <option value="<?= (int)$c['id'] ?>" data-horas="<?= htmlspecialchars($c['horas_total']) ?>" <?= $selected ?>>
                                    <?= htmlspecialchars($c['nome']) ?> (<?= htmlspecialchars(number_format($c['horas_total'], 0)) ?>h)
                                </option>
                            <?php endwhile; ?>
                        </select>
                        <input type="hidden" name="horas_total" id="horas_total">
                    </div>
                    <div>
                        <label>Total Aulas Estudadas</label>
                        <input type="number" name="aulas_estudadas" id="aulas_estudadas" value="<?= (int)$cancelamento['aulas_estudadas'] ?>" min="0">
                    </div>
                    <div>
                        <label>Duração da Aula (horas)</label>
                        <input type="text" name="duracao_aula" id="duracao_aula" value="<?= number_format($cancelamento['duracao_aula'], 2, ',', '.') ?>" inputmode="decimal">
                    </div>
                </div>
            </div>
            <div class="card">
                <h2>Cálculo Financeiro</h2>
                 <div class="grid col-4">
                    <div>
                        <label>Total Pago pelo Aluno (R$)</label>
                        <input type="text" name="parcelas_pagas" id="parcelas_pagas" value="<?= number_format($cancelamento['parcelas_pagas'], 2, ',', '.') ?>" inputmode="decimal">
                    </div>
                    <div>
                        <label>% Multa de Cancelamento</label>
                        <input type="text" name="percentual_multa" id="percentual_multa" value="<?= number_format($cancelamento['percentual_multa'], 0) ?>" inputmode="decimal">
                    </div>
                    <div class="col-item col-span-2">
                        <label>Valor Total do Curso (Base p/ Multa)</label>
                        <input type="text" name="valor_total_curso" id="valor_total_curso" value="<?= number_format($cancelamento['valor_total_curso'], 2, ',', '.') ?>" inputmode="decimal">
                    </div>
                </div>
            </div>
            <div class="card">
                <h2>Histórico da Conversa</h2>
                <textarea name="historico_conversa" rows="5"><?= htmlspecialchars($cancelamento['historico_conversa']) ?></textarea>
            </div>
            <div class="card summary-card">
                <h2>Resumo do Cancelamento</h2>
                <div class="grid col-4">
                    <div class="summary-item"><span>Valor Estudado:</span> <strong id="resumo_valor_estudado">R$ 0,00</strong></div>
                    <div class="summary-item"><span>Débito/Crédito Aluno:</span> <strong id="resumo_debito_credito">R$ 0,00</strong></div>
                    <div class="summary-item"><span>Valor da Multa:</span> <strong id="resumo_valor_multa">R$ 0,00</strong></div>
                    <div class="summary-item total"><span>TOTAL A PAGAR:</span> <strong id="resumo_total_pagar">R$ 0,00</strong></div>
                </div>
            </div>
            <div class="actions" style="text-align: right;">
                <a href="listar_cancelamento.php" class="btn ghost">Cancelar</a>
                <button type="submit" class="btn primary">Salvar Alterações</button>
            </div>
        </form>
        <?php include 'footer.php'; ?>
    </main>
</div>
<script>
    // Cole aqui o JavaScript completo da calculadora, que já funciona
    document.addEventListener('DOMContentLoaded', function() {
        const brToFloat = (v) => {
            v = (v || '').toString().trim().replace(/\./g, '').replace(',', '.');
            return parseFloat(v) || 0;
        };
        const floatToBR = (n) => (n || 0).toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
        
        const fields = {
            curso: document.getElementById('curso_id'),
            horasTotal: document.getElementById('horas_total'),
            parcelasContrato: document.getElementById('parcelas_contrato'),
            valorParcela: document.getElementById('valor_parcela'),
            aulasEstudadas: document.getElementById('aulas_estudadas'),
            duracaoAula: document.getElementById('duracao_aula'),
            parcelasPagas: document.getElementById('parcelas_pagas'),
            percMulta: document.getElementById('percentual_multa'),
            totalCursoBase: document.getElementById('valor_total_curso'),
            resumoValorEstudado: document.getElementById('resumo_valor_estudado'),
            resumoDebitoCredito: document.getElementById('resumo_debito_credito'),
            resumoValorMulta: document.getElementById('resumo_valor_multa'),
            resumoTotalPagar: document.getElementById('resumo_total_pagar'),
        };

        function recalc() {
            const horasCurso = parseFloat(fields.curso.options[fields.curso.selectedIndex]?.getAttribute('data-horas') || 0);
            fields.horasTotal.value = horasCurso;

            const qtParcelas = parseInt(fields.parcelasContrato.value || '0', 10);
            const vParcela = brToFloat(fields.valorParcela.value);
            const aulas = parseInt(fields.aulasEstudadas.value || '0', 10);
            const dur = brToFloat(fields.duracaoAula.value);
            const pagas = brToFloat(fields.parcelasPagas.value);
            const pMulta = brToFloat(fields.percMulta.value);
            const vCursoBase = brToFloat(fields.totalCursoBase.value);
            
            const vHora = (horasCurso > 0) ? ((vParcela * qtParcelas) / horasCurso) : 0;
            const horasEst = aulas * dur;
            const valorEst = horasEst * vHora;
            const debitoCredito = valorEst - pagas;
            const vMulta = (pMulta / 100.0) * vCursoBase;
            const totalPagar = debitoCredito + vMulta;

            fields.resumoValorEstudado.textContent = 'R$ ' + floatToBR(valorEst);
            fields.resumoDebitoCredito.textContent = 'R$ ' + floatToBR(debitoCredito);
            fields.resumoValorMulta.textContent = 'R$ ' + floatToBR(vMulta);
            fields.resumoTotalPagar.textContent = 'R$ ' + floatToBR(totalPagar);
        }
        
        Object.values(fields).forEach(el => {
            if(el && (el.tagName === 'INPUT' || el.tagName === 'SELECT')) {
                el.addEventListener('input', recalc);
                el.addEventListener('change', recalc);
            }
        });

        // Calcula os valores iniciais quando a página carrega
        recalc();
    });
</script>
</body>
</html>