<?php
// --- LÓGICA PHP ---

// 1. Inicializar variáveis para evitar erros
$num1 = '';
$num2 = '';
$operador = '+';
$resultado = null; // Usamos null para saber que nenhum cálculo foi feito ainda

// 2. Verificar se o formulário foi enviado (se o método da requisição é POST)
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    
    // 3. Pegar os dados do formulário e garantir que são seguros
    $num1 = $_POST['num1'];
    $num2 = $_POST['num2'];
    $operador = $_POST['operador'];

    // 4. Validar os dados
    $erros = [];
    if (!is_numeric($num1)) {
        $erros[] = "O primeiro valor não é um número válido.";
    }
    if (!is_numeric($num2)) {
        $erros[] = "O segundo valor não é um número válido.";
    }

    // 5. Se não houver erros, fazer o cálculo
    if (count($erros) === 0) {
        switch ($operador) {
            case '+':
                $resultado = $num1 + $num2;
                break;
            case '-':
                $resultado = $num1 - $num2;
                break;
            case '*':
                $resultado = $num1 * $num2;
                break;
            case '/':
                // Tratamento especial para divisão por zero, um erro clássico!
                if ($num2 == 0) {
                    $resultado = "Erro: Divisão por zero não é permitida!";
                } else {
                    $resultado = $num1 / $num2;
                }
                break;
            default:
                $resultado = "Operação inválida.";
        }
    } else {
        // Se houver erros de validação, formata a mensagem
        $resultado = implode("<br>", $erros);
    }
}

?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Calculadora PHP</title>
    <style>
        body { font-family: sans-serif; display: flex; justify-content: center; align-items: center; height: 100vh; background-color: #f0f0f0; }
        .calculadora { background: white; padding: 20px; border-radius: 8px; box-shadow: 0 4px 8px rgba(0,0,0,0.1); }
        .calculadora h1 { text-align: center; }
        .form-group { margin-bottom: 15px; }
        input, select, button { width: 100%; padding: 10px; margin-top: 5px; box-sizing: border-box; border: 1px solid #ccc; border-radius: 4px; }
        button { background-color: #007bff; color: white; border: none; cursor: pointer; font-weight: bold; }
        button:hover { background-color: #0056b3; }
        .resultado { margin-top: 20px; padding: 15px; background-color: #e9ecef; border: 1px solid #ced4da; border-radius: 4px; text-align: center; font-size: 1.2em; }
    </style>
</head>
<body>

    <div class="calculadora">
        <h1>Calculadora Simples em PHP</h1>
        
        <form action="calculadora.php" method="post">
            <div class="form-group">
                <label for="num1">Primeiro Número:</label>
                <input type="number" id="num1" name="num1" value="<?= htmlspecialchars($num1) ?>" required>
            </div>
            
            <div class="form-group">
                <label for="operador">Operação:</label>
                <select id="operador" name="operador">
                    <option value="+" <?= $operador == '+' ? 'selected' : '' ?>>Adição (+)</option>
                    <option value="-" <?= $operador == '-' ? 'selected' : '' ?>>Subtração (-)</option>
                    <option value="*" <?= $operador == '*' ? 'selected' : '' ?>>Multiplicação (*)</option>
                    <option value="/" <?= $operador == '/' ? 'selected' : '' ?>>Divisão (/)</option>
                </select>
            </div>

            <div class