<?php
// MOSTRAR TODOS OS ERROS
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

echo "<h1>Iniciando Teste Final de Conexão</h1>";

include 'conexao.php';

// Verificamos se a conexão foi bem-sucedida
if ($conn->connect_error) {
    die("<h2>FALHA NA CONEXÃO: " . $conn->connect_error . "</h2>");
}
echo "<p>Conexão com o banco de dados bem-sucedida.</p>";

// Definimos os IDs manualmente para o teste
$id_professor = 59;
$id_escola = 1;

echo "<p>Procurando por Professor ID: $id_professor E Escola ID: $id_escola</p><hr>";

// A consulta exata que está a falhar
$sql = "SELECT 
            p.nome AS prof_nome,
            e.nome AS escola_nome
        FROM 
            professores p
        JOIN 
            escolas e ON p.id_escola = e.id
        WHERE 
            p.id = ? AND p.id_escola = ?";

$stmt = $conn->prepare($sql);

if ($stmt === false) {
    die("<h2>FALHA na preparação da consulta: " . htmlspecialchars($conn->error) . "</h2>");
}

$stmt->bind_param("ii", $id_professor, $id_escola);
$stmt->execute();
$result = $stmt->get_result();

// O veredito final
if ($result->num_rows > 0) {
    echo "<h1>✅ SUCESSO!</h1>";
    echo "<p>A consulta executada via PHP encontrou o professor.</p>";
    $dados = $result->fetch_assoc();
    echo "<pre>";
    print_r($dados);
    echo "</pre>";
} else {
    echo "<h1>❌ FALHA.</h1>";
    echo "<p>A consulta executada via PHP NÃO encontrou o professor, mesmo a consulta estando correta.</p>";
    echo "<p><b>Conclusão:</b> O problema é uma questão de configuração no ambiente do servidor/PHP/MySQL que está a impedir esta consulta específica de funcionar via script.</p>";
}

$stmt->close();
$conn->close();

?>