<?php
// MOSTRAR TODOS OS ERROS
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include 'verifica_login.php';
include 'conexao.php';
$id_escola = $_SESSION['id_escola'];

// Ação acontece apenas se for um POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    die("Acesso inválido.");
}

$id_cancelamento = (int)($_GET['id'] ?? 0);
if ($id_cancelamento <= 0) {
    die("ID de cancelamento inválido.");
}

// Coletamos apenas dois campos para o teste
$aluno_nome         = trim($_POST['aluno_nome'] ?? '');
$historico_conversa = trim($_POST['historico_conversa'] ?? '');

// SQL super simplificado
$sql = "UPDATE cancelamentos SET 
            aluno_nome = ?, 
            historico_conversa = ?
        WHERE 
            id = ? AND id_escola = ?";

$stmt = $conn->prepare($sql);

if ($stmt === false) {
    die("Erro ao preparar a consulta: " . $conn->error);
}

// Tipos e variáveis correspondentes ao SQL simplificado
$stmt->bind_param("ssii",
    $aluno_nome,
    $historico_conversa,
    $id_cancelamento,
    $id_escola
);

if ($stmt->execute()) {
    // Se funcionar, redireciona de volta para a lista
    header("Location: listar_cancelamento.php?msg=teste_sucesso");
    exit;
} else {
    // Se falhar, mostra o erro
    die("Erro ao executar o update: " . $stmt->error);
}

?>