<?php
// Inicia a sessão para poder manipulá-la.
session_start();

// Limpa todas as variáveis da sessão (ex: usuario_id, id_escola, etc.).
$_SESSION = array();

// Garante que a sessão seja completamente destruída.
if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
        $params["path"], $params["domain"],
        $params["secure"], $params["httponly"]
    );
}
session_destroy();

// Redireciona o usuário para a página de login com uma mensagem de sucesso.
header("Location: login.php?msg=logout_sucesso");
exit;
?>