<?php
session_start();

// Se o utilizador já está logado, redireciona para a página principal
if (isset($_SESSION['usuario_id'])) {
    header("Location: professores.php"); // Ou outra página principal como index.php
    exit;
}

include 'conexao.php';
$mensagem_erro = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = $_POST['email'] ?? '';
    $senha = $_POST['senha'] ?? '';

    if (empty($email) || empty($senha)) {
        $mensagem_erro = "Por favor, preencha o e-mail e a senha.";
    } else {
        $stmt = $conn->prepare("SELECT id, id_escola, nome, senha, nivel FROM usuarios WHERE email = ?");
        $stmt->bind_param("s", $email);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if ($result->num_rows === 1) {
            $usuario = $result->fetch_assoc();
            
            if (password_verify($senha, $usuario['senha'])) {
                session_regenerate_id(true);
                $_SESSION['usuario_id'] = $usuario['id'];
                $_SESSION['usuario_nome'] = $usuario['nome'];
                $_SESSION['id_escola'] = $usuario['id_escola'];
                $_SESSION['usuario_nivel'] = $usuario['nivel'];

                header("Location: professores.php");
                exit;
            }
        }
        $mensagem_erro = "E-mail ou senha inválidos.";
    }
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8">
<style>
/* Estilos para a página de login */
:root {
    --bg: #f6f8fb; --card: #fff; --muted: #64748b; --text: #0f172a;
    --accent: #4f46e5; --bad: #ef4444; --border: #e5e7eb;
}
* { box-sizing: border-box; }
body { font-family: Inter, Segoe UI, Roboto, Arial, sans-serif; background: var(--bg); color: var(--text); margin: 0; display: flex; align-items: center; justify-content: center; min-height: 100vh; }
.login-container { width: 100%; max-width: 400px; padding: 16px; }
.card { background: var(--card); border: 1px solid var(--border); border-radius: 14px; padding: 32px; box-shadow: 0 10px 30px rgba(15,23,42,.04); }
h1 { font-size: 24px; text-align: center; margin: 0 0 24px; }
label { font-size: 13px; color: var(--muted); display: block; margin-bottom: 6px; font-weight: 500; }
input { width: 100%; padding: 12px; border: 1px solid var(--border); border-radius: 10px; font-size: 14px; margin-bottom: 16px; }
.btn { width: 100%; border: none; border-radius: 10px; padding: 14px; cursor: pointer; font-weight: 600; font-size: 15px; }
.btn.primary { background: var(--accent); color: #fff; }
.msg.err { text-align: center; padding: 12px; border-radius: 10px; margin-bottom: 16px; background: #fef2f2; color: #991b1b; }
</style>
<title>Login - Sistema de Gestão</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="style.css">
</head>
<body>
<div class="login-container">
    <div class="card">
        <h1>Acessar Sistema</h1>

        <?php if (isset($_GET['registo']) && $_GET['registo'] == 'sucesso'): ?>
            <div class="msg ok" style="text-align:center;">
                Registo efetuado com sucesso! Por favor, faça o login.
            </div>
        <?php endif; ?>

        <?php if ($mensagem_erro): ?>
            <div class="msg err"><?= htmlspecialchars($mensagem_erro) ?></div>
        <?php endif; ?>

        <form method="post">
            <div>
                <label for="email">E-mail</label>
                <input type="email" name="email" id="email" required>
            </div>
            <div>
                <label for="senha">Senha</label>
                <input type="password" name="senha" id="senha" required>
            </div>
            <button type="submit" class="btn primary">Entrar</button>
        </form>

        <div style="text-align: center; margin-top: 16px; font-size: 14px;">
            Ainda não tem uma conta? <a href="registrar.php">Registe a sua escola</a>
        </div>
    </div>
</div>
</body>
</html>