<?php
// =================================================================
// BLOCO DE INÍCIO PADRÃO
// =================================================================
include 'verifica_login.php';
include 'conexao.php';
$id_escola = $_SESSION['id_escola'];
$nome_usuario = $_SESSION['usuario_nome'];
$nivel_usuario = $_SESSION['usuario_nivel'];
// =================================================================

// --- LÓGICA DE FILTRAGEM SEGURA E DINÂMICA ---
$params = [$id_escola];
$types = 'i';
$filtros_sql = [];

// Base da query
$sql_base = "SELECT 
                c.id, 
                c.aluno_nome, 
                c.valor_total_a_pagar, 
                c.data_registro,
                cu.nome AS curso_nome
            FROM 
                cancelamentos c
            JOIN 
                cursos cu ON c.curso_id = cu.id
            WHERE 
                c.id_escola = ?";

// Adiciona filtros dinâmicos do formulário
if (!empty($_GET['aluno'])) {
    $filtros_sql[] = "c.aluno_nome LIKE ?";
    $params[] = '%' . $_GET['aluno'] . '%';
    $types .= 's';
}
if (!empty($_GET['curso_id'])) {
    $filtros_sql[] = "c.curso_id = ?";
    $params[] = (int)$_GET['curso_id'];
    $types .= 'i';
}

// Junta todos os filtros na query principal
$sql = $sql_base;
if (count($filtros_sql) > 0) {
    $sql .= ' AND ' . implode(' AND ', $filtros_sql);
}
$sql .= " ORDER BY c.data_registro DESC";

$stmt = $conn->prepare($sql);
if ($stmt && count($params) > 0) {
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$result = $stmt->get_result();

// --- Busca cursos APENAS da escola logada para o filtro ---
$cursos_filtro_res = $conn->prepare("SELECT id, nome FROM cursos WHERE id_escola = ? ORDER BY nome");
$cursos_filtro_res->bind_param("i", $id_escola);
$cursos_filtro_res->execute();
$cursos_filtro = $cursos_filtro_res->get_result();
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8">
<title>Lista de Cancelamentos</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="style.css">
</head>
<body>

<div class="app-container">
    <?php include 'menu.php'; ?>

    <main class="main-content">
        <div class="header-actions">
    <br></br>      <br></br>  <br></br><h1>Cancelamentos Registados</h1>
            <a class="btn primary" href="cancelamento_novo.php">+ Novo Cancelamento</a>
        </div>

        <div class="card">
            <form method="get" autocomplete="off">
                <div class="filter-grid" style="grid-template-columns: 2fr 2fr 1fr 1fr; align-items: flex-end;">
                    <div>
                        <label>Pesquisar por aluno</label>
                        <input type="text" name="aluno" value="<?= htmlspecialchars($_GET['aluno'] ?? '') ?>">
                    </div>
                    <div>
                        <label>Filtrar por curso</label>
                        <select name="curso_id">
                            <option value="">Todos os cursos</option>
                            <?php while ($curso = $cursos_filtro->fetch_assoc()): ?>
                                <option value="<?= $curso['id'] ?>" <?= (($_GET['curso_id'] ?? '') == $curso['id']) ? 'selected' : '' ?>>
                                    <?= htmlspecialchars($curso['nome']) ?>
                                </option>
                            <?php endwhile; ?>
                        </select>
                    </div>
                    <div>
                        <button type="submit" class="btn secondary" style="width: 100%;">Pesquisar</button>
                    </div>
                    <div>
                        <a href="listar_cancelamento.php" class="btn ghost" style="width: 100%;">Limpar</a>
                    </div>
                </div>
            </form>
        </div>

        <div class="card">
            <table>
                <thead>
                    <tr>
                        <th>Aluno</th>
                        <th>Curso</th>
                        <th>Valor Total a Pagar</th>
                        <th>Data Registro</th>
                        <th>Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($result && $result->num_rows > 0): ?>
                        <?php while ($row = $result->fetch_assoc()): ?>
                            <tr>
                                <td><?= htmlspecialchars($row['aluno_nome']) ?></td>
                                <td><?= htmlspecialchars($row['curso_nome']) ?></td>
                                <td>R$ <?= number_format($row['valor_total_a_pagar'], 2, ',', '.') ?></td>
                                <td><?= date('d/m/Y H:i', strtotime($row['data_registro'])) ?></td>
                                <td class="actions-cell">
                                    <a href="editar_cancelamento.php?id=<?= $row['id'] ?>">Editar</a>
                                    <a href="excluir_cancelamento.php?id=<?= $row['id'] ?>" class="delete" onclick="return confirm('Tem certeza?')">Excluir</a>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr><td colspan="5">Nenhum cancelamento encontrado.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        
        <?php include 'footer.php'; ?>
    </main>
</div>

</body>
</html>