<?php
// importar_professores_txt.php
error_reporting(E_ALL);
ini_set('display_errors', 1);
include 'conexao.php';

function normaliza_decimal($s) {
    $s = trim((string)$s);
    if ($s === '') return '';
    // remove espaços, substitui milhar e decimal: "1.234,56" -> "1234.56"
    $s = str_replace(["\xC2\xA0", ' '], '', $s);
    $s = str_replace('.', '', $s);
    $s = str_replace(',', '.', $s);
    return $s;
}

function normaliza_data($s) {
    $s = trim((string)$s);
    if ($s === '') return '';
    // dd/mm/aaaa ou dd-mm-aaaa -> aaaa-mm-dd
    if (preg_match('~^(\d{2})[\/\-](\d{2})[\/\-](\d{4})$~', $s, $m)) {
        return $m[3] . '-' . $m[2] . '-' . $m[1];
    }
    // aaaa-mm-dd já OK
    if (preg_match('~^\d{4}-\d{2}-\d{2}$~', $s)) return $s;
    // tenta via strtotime; se não der, devolve original (sem validar)
    $ts = strtotime($s);
    if ($ts) return date('Y-m-d', $ts);
    return $s;
}

function limpar($s) { return trim((string)$s); }

$step = isset($_POST['confirm']) ? 'confirm' : (isset($_POST['preview']) ? 'preview' : 'form');

$delim = ';'; // fixo em ';' como combinamos
$colunas = [
    'nome','valor_hora_aula','data_admissao','data_demissao','cpf','rg','estado_civil',
    'escola','endereco','telefone','area_curso','nome_curso','pix','banco','observacoes',
    'dia_pagamento','ajuda_custo'
];

$erros = [];
$linhas = [];
$preview_rows = [];

if ($step === 'preview') {
    if (empty($_FILES['arquivo']['tmp_name'])) {
        $erros[] = 'Envie um arquivo .txt separado por ponto e vírgula.';
        $step = 'form';
    } else {
        $raw = file($_FILES['arquivo']['tmp_name'], FILE_IGNORE_NEW_LINES);
        if ($raw === false || count($raw) === 0) {
            $erros[] = 'Não foi possível ler o arquivo ou arquivo vazio.';
            $step = 'form';
        } else {
            $temCabecalho = !empty($_POST['tem_cabecalho']);
            $lineno = 0;
            foreach ($raw as $line) {
                $lineno++;
                $line = rtrim($line, "\r\n");
                if ($line === '') continue;
                // separa pelos ';'
                $parts = explode($delim, $line);
                // se tem cabeçalho, pula a primeira linha
                if ($temCabecalho && $lineno === 1) {
                    // opcionalmente, poderíamos checar nomes das colunas aqui
                    continue;
                }
                // garante 17 colunas
                if (count($parts) < count($colunas)) {
                    // completa com vazio
                    $parts = array_pad($parts, count($colunas), '');
                } elseif (count($parts) > count($colunas)) {
                    // sobra: junta o excedente na última coluna (observações, por ex.)
                    $resto = array_slice($parts, count($colunas)-1);
                    $parts = array_slice($parts, 0, count($colunas)-1);
                    $parts[] = implode(' ', $resto);
                }

                $row = array_combine($colunas, array_map('limpar', $parts));

                // normalizações leves (apenas para visual e para o POST de confirmação)
                $row['valor_hora_aula'] = normaliza_decimal($row['valor_hora_aula']);
                $row['ajuda_custo']     = normaliza_decimal($row['ajuda_custo']);
                $row['data_admissao']   = normaliza_data($row['data_admissao']);
                $row['data_demissao']   = normaliza_data($row['data_demissao']);

                $linhas[] = $row;
            }
            $preview_rows = array_slice($linhas, 0, 200); // mostra no máximo 200 linhas
        }
    }
}

if ($step === 'confirm' && !empty($_POST['payload'])) {
    $linhas = json_decode($_POST['payload'], true);
    if (!is_array($linhas)) {
        $erros[] = 'Carga inválida. Refaça o upload.';
        $step = 'form';
    } else {
        $inseridos = 0;
        $atualizados = 0;
        $falhas = 0;
        $detalhes_erro = [];

        // Preparações (iremos preparar dentro do loop, pois tipos iguais; mas podemos reusar)
        foreach ($linhas as $idx => $row) {
            // garante chaves
            foreach ($colunas as $c) {
                if (!array_key_exists($c, $row)) $row[$c] = '';
            }

            // normalizações finais
            $row['valor_hora_aula'] = normaliza_decimal($row['valor_hora_aula']);
            $row['ajuda_custo']     = normaliza_decimal($row['ajuda_custo']);
            $row['data_admissao']   = normaliza_data($row['data_admissao']);
            $row['data_demissao']   = normaliza_data($row['data_demissao']);

            // decide se existe (por CPF não vazio)
            $exists = false;
            if ($row['cpf'] !== '') {
                $stmt = $conn->prepare("SELECT id FROM professores WHERE cpf = ? LIMIT 1");
                if ($stmt) {
                    $stmt->bind_param("s", $row['cpf']);
                    $stmt->execute();
                    $stmt->store_result();
                    $exists = $stmt->num_rows > 0;
                    $stmt->close();
                }
            }

            if ($exists) {
                // UPDATE por CPF
                $sql = "UPDATE professores SET
                    nome=?, valor_hora_aula=?, data_admissao=?, data_demissao=?, rg=?, estado_civil=?, escola=?, endereco=?, telefone=?, area_curso=?, nome_curso=?, pix=?, banco=?, observacoes=?, dia_pagamento=?, ajuda_custo=?
                    WHERE cpf=?";
                $stmt = $conn->prepare($sql);
                if (!$stmt) {
                    $falhas++; $detalhes_erro[] = "Linha ".($idx+1).": falha prepare UPDATE - " . $conn->error;
                    continue;
                }
                $stmt->bind_param(
                    "sssssssssssssssss",
                    $row['nome'], $row['valor_hora_aula'], $row['data_admissao'], $row['data_demissao'], $row['rg'], $row['estado_civil'],
                    $row['escola'], $row['endereco'], $row['telefone'], $row['area_curso'], $row['nome_curso'], $row['pix'], $row['banco'], $row['observacoes'],
                    $row['dia_pagamento'], $row['ajuda_custo'], $row['cpf']
                );
                if ($stmt->execute()) $atualizados++; else { $falhas++; $detalhes_erro[] = "Linha ".($idx+1).": ".$stmt->error; }
                $stmt->close();
            } else {
                // INSERT
                $sql = "INSERT INTO professores
                    (nome, valor_hora_aula, data_admissao, data_demissao, cpf, rg, estado_civil, escola, endereco, telefone, area_curso, nome_curso, pix, banco, observacoes, dia_pagamento, ajuda_custo)
                    VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                $stmt = $conn->prepare($sql);
                if (!$stmt) {
                    $falhas++; $detalhes_erro[] = "Linha ".($idx+1).": falha prepare INSERT - " . $conn->error;
                    continue;
                }
                $stmt->bind_param(
                    "sssssssssssssssss",
                    $row['nome'], $row['valor_hora_aula'], $row['data_admissao'], $row['data_demissao'], $row['cpf'], $row['rg'], $row['estado_civil'],
                    $row['escola'], $row['endereco'], $row['telefone'], $row['area_curso'], $row['nome_curso'], $row['pix'], $row['banco'], $row['observacoes'],
                    $row['dia_pagamento'], $row['ajuda_custo']
                );
                if ($stmt->execute()) $inseridos++; else { $falhas++; $detalhes_erro[] = "Linha ".($idx+1).": ".$stmt->error; }
                $stmt->close();
            }
        }

        // Resultado final
        ?>
        <!DOCTYPE html>
        <html lang="pt-br">
        <head>
            <meta charset="utf-8">
            <meta name="viewport" content="width=device-width,initial-scale=1">
            <title>Importação de Instrutores</title>
            <style>
                body{font-family:Inter,Segoe UI,Arial,sans-serif;background:#f6f7fb;margin:0;padding:24px;color:#0f172a}
                .box{max-width:1000px;margin:0 auto;background:#fff;border:1px solid #e5e7eb;border-radius:12px;padding:20px;box-shadow:0 6px 20px rgba(15,23,42,.06)}
                h1{margin:0 0 12px 0;font-size:20px}
                .summary{display:flex;gap:16px;flex-wrap:wrap;margin:10px 0 16px}
                .pill{padding:8px 12px;border-radius:999px;background:#eef2ff;color:#3730a3;font-weight:600}
                .err{background:#fef2f2;color:#991b1b}
                .list{margin-top:12px}
                a.btn{display:inline-block;margin-top:14px;padding:10px 14px;border-radius:10px;background:#111827;color:#fff;text-decoration:none}
                pre{background:#f8fafc;padding:10px;border-radius:8px;overflow:auto}
            </style>
        </head>
        <body>
            <div class="box">
                <h1>Importação concluída</h1>
                <div class="summary">
                    <div class="pill">Inseridos: <?= (int)$inseridos ?></div>
                    <div class="pill">Atualizados: <?= (int)$atualizados ?></div>
                    <div class="pill err">Erros: <?= (int)$falhas ?></div>
                </div>
                <?php if (!empty($detalhes_erro)): ?>
                    <div class="list">
                        <strong>Detalhes de erro:</strong>
                        <pre><?php foreach ($detalhes_erro as $e) echo htmlspecialchars($e)."\n"; ?></pre>
                    </div>
                <?php endif; ?>
                <a class="btn" href="importar_professores_txt.php">← Nova importação</a>
            </div>
        </body>
        </html>
        <?php
        exit;
    }
}

// FORM + PREVIEW
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>Importar Instrutores (TXT)</title>
<style>
    body{font-family:Inter,Segoe UI,Arial,sans-serif;background:#f6f7fb;margin:0;padding:24px;color:#0f172a}
    .box{max-width:1100px;margin:0 auto;background:#fff;border:1px solid #e5e7eb;border-radius:12px;padding:20px;box-shadow:0 6px 20px rgba(15,23,42,.06)}
    h1{margin:0 0 14px 0;font-size:20px}
    .muted{color:#6b7280;font-size:13px}
    .row{display:flex;gap:10px;flex-wrap:wrap;align-items:center;margin:10px 0}
    input[type=file],label,select{font-size:14px}
    .btn{padding:10px 14px;border:none;border-radius:10px;background:#111827;color:#fff;cursor:pointer}
    .btn.sec{background:#4f46e5}
    .err{background:#fef2f2;color:#991b1b;border:1px solid #fecaca;padding:10px 12px;border-radius:8px;margin-bottom:12px}
    table{width:100%;border-collapse:collapse;margin-top:12px}
    th,td{border-bottom:1px solid #eef2f7;padding:8px 10px;text-align:left;font-size:13px}
    .scroll{max-height:420px;overflow:auto;border:1px solid #e5e7eb;border-radius:8px}
    code{background:#f1f5f9;padding:2px 6px;border-radius:6px}
</style>
</head>
<body>
    <?php include 'includes/menu.php'; ?>
<div class="box">
    <h1>Importar Instrutores (TXT ;)</h1> 
    <div class="muted">Formato: <code><?= implode(';', $colunas) ?></code> (com ou sem cabeçalho na primeira linha). Valores numéricos aceitam vírgula ou ponto. Datas podem ser <code>dd/mm/aaaa</code> ou <code>aaaa-mm-dd</code>.</div>

    <?php if (!empty($erros)): ?>
        <div class="err">
            <?php foreach ($erros as $e) echo htmlspecialchars($e)."<br>"; ?>
        </div>
    <?php endif; ?>

    <?php if ($step === 'form'): ?>
        <form method="post" enctype="multipart/form-data">
            <div class="row">
                <input type="file" name="arquivo" accept=".txt" required>
                <label><input type="checkbox" name="tem_cabecalho" checked> Meu arquivo tem cabeçalho</label>
                <button class="btn" name="preview" value="1" type="submit">Pré-visualizar</button>
            </div>
        </form>
        <div style="margin-top:12px">
            <strong>Exemplo de linha:</strong><br>
            <code>Nome do Instrutor;valor hora;data de cadastro;;CPF;RG;Estado Civil;Cidade;Endereço;Telefone;Área do curso;Curso;ChavePix;Banco;OBS;dia do vencimento;OBS</code>
        </div>
    <?php endif; ?>

    <?php if ($step === 'preview' && !empty($linhas)): ?>
        <form method="post">
            <input type="hidden" name="payload" value='<?= htmlspecialchars(json_encode($linhas, JSON_UNESCAPED_UNICODE)) ?>'>
            <div class="row">
                <button class="btn sec" type="submit" name="confirm" value="1">Confirmar importação</button>
                <a class="btn" style="text-decoration:none;display:inline-block" href="importar_professores_txt.php">Cancelar</a>
            </div>

            <div class="muted">Pré-visualizando <?= count($preview_rows) ?> de <?= count($linhas) ?> linhas.</div>
            <div class="scroll">
                <table>
                    <thead>
                        <tr>
                            <?php foreach ($colunas as $c): ?>
                                <th><?= htmlspecialchars($c) ?></th>
                            <?php endforeach; ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($preview_rows as $r): ?>
                            <tr>
                                <?php foreach ($colunas as $c): ?>
                                    <td><?= htmlspecialchars($r[$c] ?? '') ?></td>
                                <?php endforeach; ?>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            <div class="row">
                <button class="btn sec" type="submit" name="confirm" value="1">Confirmar importação</button>
                <a class="btn" style="text-decoration:none;display:inline-block" href="importar_professores_txt.php">Cancelar</a>
            </div>
        </form>
    <?php endif; ?>
</div>
</body>
</html>
