<?php
// importar_professores.php
function validarCPF($cpf) {
    $cpf = preg_replace('/[^0-9]/', '', $cpf);
    if (strlen($cpf) != 11 || preg_match('/(\d)\1{10}/', $cpf)) return false;
    for ($t = 9; $t < 11; $t++) {
        for ($d = 0, $c = 0; $c < $t; $c++) {
            $d += $cpf[$c] * (($t + 1) - $c);
        }
        $d = ((10 * $d) % 11) % 10;
        if ($cpf[$c] != $d) return false;
    }
    return true;
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8">
<title>Importar Instrutores</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<style>
    body { font-family: "Segoe UI", Arial, sans-serif; background: #f4f6f9; margin: 0; padding: 0; }
    .container { max-width: 1000px; margin: auto; padding: 20px; }
    h1 { text-align: center; margin-bottom: 20px; }
    form.upload { background: #fff; padding: 20px; border-radius: 10px; box-shadow: 0 2px 6px rgba(0,0,0,.1); margin-bottom: 20px; }
    input[type=file] { padding: 10px; border: 1px solid #ccc; border-radius: 6px; }
    button { background: #4CAF50; color: white; padding: 10px 15px; border: none; border-radius: 6px; cursor: pointer; }
    button:hover { background: #45a049; }
    table { border-collapse: collapse; width: 100%; background: #fff; box-shadow: 0 2px 6px rgba(0,0,0,.1); }
    th, td { border: 1px solid #ddd; padding: 8px; font-size: 14px; text-align: left; }
    th { background: #f2f2f2; }
    .erro { background: #ffe5e5; color: #b00000; }
    .ok { background: #e6ffea; color: #006600; }
    @media (max-width: 768px) {
        table, thead, tbody, th, td, tr { display: block; }
        tr { margin-bottom: 10px; border-bottom: 1px solid #ccc; }
        td { border: none; padding-left: 50%; position: relative; }
        td:before { 
            position: absolute; top: 8px; left: 8px; width: 45%; white-space: nowrap; font-weight: bold; 
            color: #555;
        }
    }
</style>
</head>
<body>
<?php include 'includes/menu.php'; ?>
<div class="container">
    <h1>Importar Instrutores</h1> <a href="modelo_importacao_professores.csv">Clique AQUI para Baixar o modelo</a>
    <form method="post" enctype="multipart/form-data" class="upload">
        <label>Selecione o arquivo CSV:</label><br><br>
        <input type="file" name="arquivo" accept=".csv" required>
        <button type="submit" name="preview">Pré-visualizar</button>
    </form>

<?php
if (isset($_POST['preview']) && isset($_FILES['arquivo'])) {
    if ($_FILES['arquivo']['error'] === 0) {
        $tmp = $_FILES['arquivo']['tmp_name'];
        $handle = fopen($tmp, 'r');
        if ($handle) {
            echo "<form method='post' action='processar_importacao.php'>";
            echo "<table><tr>
                <th>Nome</th><th>Valor Hora Aula</th><th>Data Admissão</th><th>Data Demissão</th>
                <th>CPF</th><th>RG</th><th>Estado Civil</th><th>Escola</th><th>Endereço</th>
                <th>Telefone</th><th>Área Curso</th><th>Nome Curso</th><th>PIX</th>
                <th>Banco</th><th>Observações</th><th>Dia Pagamento</th><th>Ajuda de Custo</th>
            </tr>";

            $linha = 0;
            while (($dados = fgetcsv($handle, 1000, ";")) !== FALSE) {
                if ($linha > 0) { // pula cabeçalho
                    $cpfValido = validarCPF($dados[4]);
                    $classeCPF = $cpfValido ? 'ok' : 'erro';

                    $dataAdmOk = (strtotime($dados[2]) !== false);
                    $dataDemOk = (empty($dados[3]) || strtotime($dados[3]) !== false);

                    echo "<tr>";
                    foreach ($dados as $index => $campo) {
                        $classe = '';
                        if ($index == 4) $classe = $classeCPF;
                        if (($index == 2 && !$dataAdmOk) || ($index == 3 && !$dataDemOk)) $classe = 'erro';
                        echo "<td class='{$classe}'>" . htmlspecialchars($campo) . "</td>";
                    }
                    echo "</tr>";
                    echo "<input type='hidden' name='dados[]' value='".htmlspecialchars(implode(";", $dados))."'>";
                }
                $linha++;
            }
            fclose($handle);
            echo "</table>";
            echo "<br><button type='submit'>Importar Professores</button>";
            echo "</form>";
        }
    } else {
        echo "<p style='color:red;'>Erro ao enviar o arquivo.</p>";
    }
}
?>
</div>
</body>
</html>
