<?php
// Este arquivo foi recriado do zero para garantir que não há caracteres invisíveis (BOM).

// Inicia o buffer de saída para capturar qualquer saída inesperada.
ob_start();

session_start();
require('fpdf.php');
include 'conexao.php';

// --- CONFIGURAÇÃO E VALIDAÇÃO ---
$id_escola = 1; // Definição estática. Será trocado pelo login.

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    die("Erro: ID do professor não fornecido ou inválido.");
}
$id_professor = (int)$_GET['id'];

// --- CONSULTA SEGURA AO BANCO DE DADOS ---
$sql = "SELECT 
            p.nome AS prof_nome, p.estado_civil AS prof_estado_civil, p.rg AS prof_rg, p.cpf AS prof_cpf, 
            p.endereco AS prof_endereco, p.valor_hora_aula, p.data_admissao,
            e.nome AS escola_nome, e.cnpj AS escola_cnpj, e.endereco_completo AS escola_endereco, 
            e.representante AS escola_representante, e.rg_representante AS escola_rg_rep, e.cpf_representante AS escola_cpf_rep,
            e.cidade AS escola_cidade
        FROM 
            professores p
        JOIN 
            escolas e ON p.id_escola = e.id
        WHERE 
            p.id = ? AND p.id_escola = ?";

$stmt = $conn->prepare($sql);

if ($stmt === false) {
    ob_end_clean(); // Limpa o buffer antes de mostrar o erro
    die("Erro ao preparar a consulta SQL: " . htmlspecialchars($conn->error));
}

$stmt->bind_param("ii", $id_professor, $id_escola);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    ob_end_clean(); // Limpa o buffer antes de mostrar o erro
    die("Professor não encontrado ou não pertence à sua escola. Verifique o ID do professor e da escola.");
}
$dados = $result->get_result()->fetch_assoc();
$stmt->close();

// Se tudo deu certo até aqui, limpa o buffer e começa a gerar o PDF.
ob_end_clean();

// --- PREPARAÇÃO DOS DADOS PARA O PDF ---
setlocale(LC_TIME, 'pt_BR.UTF-8', 'pt_BR', 'portuguese');
date_default_timezone_set('America/Sao_Paulo');
$data_inicio  = strftime("%d de %B de %Y", strtotime($dados['data_admissao']));
$data_termino = strftime("%d de %B de %Y", strtotime("+1 year", strtotime($dados['data_admissao'])));
$valor_hora_aula_formatado = "R$ " . number_format($dados['valor_hora_aula'], 2, ',', '.');

// --- CLASSE DO PDF ---
class PDF extends FPDF
{
    function Header() {
        if (file_exists('logo.png')) {
            $this->Image('logo.png', 10, 6, 40);
        }
        $this->SetFont('Arial', 'B', 12);
        $this->Cell(0, 10, utf8_decode('CONTRATO PARTICULAR DE PRESTAÇÃO DE SERVIÇOS DE TRABALHO AUTÔNOMO'), 0, 1, 'C');
        $this->Ln(5);
    }
    function Footer() {
        $this->SetY(-15);
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(0, 5, utf8_decode('Data de emissão: ' . date('d/m/Y')), 0, 1, 'L');
        $this->Cell(0, 5, utf8_decode('Página ') . $this->PageNo() . '/{nb}', 0, 0, 'R');
    }
    function ChapterBody($txt) {
        $this->SetFont('Arial', '', 11);
        $this->MultiCell(0, 6, utf8_decode($txt));
        $this->Ln();
    }
}

// --- GERAÇÃO DO PDF ---
$pdf = new PDF();
$pdf->AliasNbPages();
$pdf->AddPage();

// --- TEXTO DO CONTRATO ---
$texto = "Pelo presente Instrumento Particular de Contrato de Prestação de Trabalho Autônomo, de um lado {$dados['escola_nome']} devidamente inscrita no CNPJ nº {$dados['escola_cnpj']}, situada na {$dados['escola_endereco']}, neste ato devidamente representado por sua sócia proprietária, {$dados['escola_representante']}, brasileira, casada, Administrador de Empresas, RG {$dados['escola_rg_rep']} e CPF {$dados['escola_cpf_rep']} doravante denominado CONTRATANTE, e de outro lado, {$dados['prof_nome']}, {$dados['prof_estado_civil']}, RG Nº {$dados['prof_rg']} CPF Nº {$dados['prof_cpf']} com endereço em {$dados['prof_endereco']}, neste ato doravante denominado de CONTRATADO... [SEU TEXTO COMPLETO DO CONTRATO AQUI] ... E, por estarem assim justos e contratados, assinam o presente instrumento em duas vias de igual teor e forma, na presença de duas testemunhas.\n\n" .
"{$dados['escola_cidade']}, _____ de _________________________ de _____.\n\n\n" .
"CONTRATANTE: ______________________________________\n" .
"{$dados['escola_nome']}\n\n" .
"CONTRATADO: ______________________________________\n" .
"{$dados['prof_nome']}\n\n\n" .
"Testemunhas:\n" .
"1. _______________________________________________\n\n" .
"2. _______________________________________________";

$pdf->ChapterBody($texto);
$pdf->Output("I", "Contrato_Professor_" . preg_replace('/[^a-zA-Z0-9]/', '_', $dados['prof_nome']) . ".pdf");
exit;
?>