<?php
session_start();
include 'conexao.php';

// --- LÓGICA MULTI-ESCOLA E SEGURANÇA DE ACESSO ---
$id_escola = 1; // Definição estática. Será trocado pelo login.

// 1. Validação do ID
$id_curso = $_GET['id'] ?? null;
if (!$id_curso || !is_numeric($id_curso)) {
    header("Location: listar_cursos.php?msg=erro_id_invalido");
    exit;
}

// 2. Preparação da query de exclusão segura
$sql = "DELETE FROM cursos WHERE id = ? AND id_escola = ?";
$stmt = $conn->prepare($sql);

if ($stmt) {
    $stmt->bind_param("ii", $id_curso, $id_escola);
    
    if ($stmt->execute()) {
        header("Location: listar_cursos.php?msg=excluido_sucesso");
        exit;
    }
}

// Se chegou até aqui, algo deu errado
header("Location: listar_cursos.php?msg=erro_excluir");
exit;
?>