<?php
include 'conexao.php';

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    die("ID inválido.");
}

$id = (int)$_GET['id'];

// Buscar registro
$stmt = $conn->prepare("SELECT * FROM ponto WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$res = $stmt->get_result();
if ($res->num_rows === 0) {
    die("Registro de ponto não encontrado.");
}
$ponto = $res->fetch_assoc();

// Atualizar
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id_professor = $_POST['id_professor'] ?? '';
    $data_ponto   = $_POST['data_ponto'] ?? '';
    $hora_entrada = $_POST['hora_entrada'] ?? '';
    $hora_saida   = $_POST['hora_saida'] ?? '';
    $observacoes  = $_POST['observacoes'] ?? '';

    $stmt_up = $conn->prepare("UPDATE ponto SET id_professor=?, data_ponto=?, hora_entrada=?, hora_saida=?, observacoes=? WHERE id=?");
    $stmt_up->bind_param("issssi", $id_professor, $data_ponto, $hora_entrada, $hora_saida, $observacoes, $id);
    if ($stmt_up->execute()) {
        header("Location: ponto.php");
        exit;
    } else {
        echo "Erro ao atualizar: " . $stmt_up->error;
    }
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8">
<title>Editar Ponto</title>
<style>
body { font-family: sans-serif; background: #f4f4f4; margin: 0; }
.container { max-width: 600px; margin: 40px auto; background: white; padding: 20px; border-radius: 8px; }
label { display: block; margin-top: 10px; }
input, select, textarea { width: 100%; padding: 8px; margin-top: 5px; }
button { margin-top: 15px; padding: 10px 20px; background: #2980b9; color: white; border: none; border-radius: 5px; cursor: pointer; }
button:hover { background: #1c5980; }
</style>
</head>
<body>
    <div class="app-container">
        <?php include 'menu.php'; // Nosso menu lateral ?>

        <main class="main-content">
            </main>

        <?php include 'footer.php'; // <<-- ADICIONE ESTA LINHA AQUI ?>
    </div>
<div class="container">
    <h2>Editar Ponto</h2>
    <form method="post">
        <label>Professor</label>
        <select name="id_professor" required>
            <?php
            $profQuery = $conn->query("SELECT id, nome FROM professores ORDER BY nome");
            while ($p = $profQuery->fetch_assoc()) {
                $sel = ($p['id'] == $ponto['id_professor']) ? 'selected' : '';
                echo "<option value='{$p['id']}' $sel>" . htmlspecialchars($p['nome']) . "</option>";
            }
            ?>
        </select>

        <label>Data</label>
        <input type="date" name="data_ponto" value="<?= htmlspecialchars($ponto['data_ponto']) ?>" required>

        <label>Hora de Entrada</label>
        <input type="time" name="hora_entrada" value="<?= htmlspecialchars($ponto['hora_entrada']) ?>">

        <label>Hora de Saída</label>
        <input type="time" name="hora_saida" value="<?= htmlspecialchars($ponto['hora_saida']) ?>">

        <label>Observações</label>
        <textarea name="observacoes"><?= htmlspecialchars($ponto['observacoes']) ?></textarea>

        <button type="submit">Salvar Alterações</button>
    </form>
</div>
</body>
</html>
