<?php
// Este ficheiro agora SÓ MOSTRA o formulário.
include 'verifica_login.php';
include 'conexao.php';
$id_escola = $_SESSION['id_escola'];

$id_cancelamento = (int)($_GET['id'] ?? 0);
if ($id_cancelamento <= 0) {
    die("ID de cancelamento inválido.");
}

// Busca dados do cancelamento para preencher o formulário
$stmt_get = $conn->prepare("SELECT * FROM cancelamentos WHERE id = ? AND id_escola = ?");
$stmt_get->bind_param("ii", $id_cancelamento, $id_escola);
$stmt_get->execute();
$cancelamento = $stmt_get->get_result()->fetch_assoc();

if (!$cancelamento) {
    die("Cancelamento não encontrado ou não pertence à sua escola.");
}

// Busca cursos para o dropdown
$cursos_res = $conn->prepare("SELECT id, nome, horas_total FROM cursos WHERE id_escola = ? ORDER BY nome");
$cursos_res->bind_param("i", $id_escola);
$cursos_res->execute();
$cursos = $cursos_res->get_result();
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8">
<title>Editar Cancelamento</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="style.css">
</head>
<body>
<div class="app-container">
    <?php include 'menu.php'; ?>
    <main class="main-content">
        <h1>Editar Registo de Cancelamento</h1>
        
        <form method="post" action="salvar_cancelamento.php?id=<?= $id_cancelamento ?>" id="form-cancel">
            </form>

        <?php include 'footer.php'; ?>
    </main>
</div>
<script>
    // O JavaScript para o cálculo em tempo real continua igual aqui
</script>
</body>
</html>