<?php
// MOSTRAR TODOS OS ERROS - para garantir que não há erros escondidos
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// INICIAMOS A SESSÃO MANUALMENTE NO TOPO
session_start();

// VERIFICAÇÃO MANUAL
if (!isset($_SESSION['usuario_id']) || !isset($_SESSION['id_escola'])) {
    die("ERRO: A sessão não foi carregada corretamente. Tente fazer logout e login novamente.");
}

// INCLUÍMOS A CONEXÃO
include 'conexao.php';
if ($conn->connect_error) {
    die("FALHA NA CONEXÃO: " . $conn->connect_error);
}

// DEFINIMOS AS VARIÁVEIS A PARTIR DA SESSÃO E URL
$id_escola_sessao = (int)$_SESSION['id_escola'];
$id_professor_url = (int)($_GET['id_prof'] ?? 0);
$id_modelo_url = (int)($_GET['id_modelo'] ?? 0);

if ($id_professor_url <= 0 || $id_modelo_url <= 0) {
    die("ID do professor ou do modelo de contrato inválido na URL.");
}

// Busca os dados do professor e da escola
$sql_prof = "SELECT 
                p.nome AS prof_nome, p.estado_civil AS prof_estado_civil, p.rg AS prof_rg, p.cpf AS prof_cpf, 
                p.endereco AS prof_endereco, p.valor_hora_aula, p.data_admissao,
                e.nome AS escola_nome, e.cnpj AS escola_cnpj, e.endereco_completo AS escola_endereco, 
                e.representante AS escola_representante, e.rg_representante AS escola_rg_rep, e.cpf_representante AS escola_cpf_rep,
                e.cidade AS escola_cidade
            FROM professores p
            JOIN escolas e ON p.id_escola = e.id
            WHERE p.id = ? AND p.id_escola = ?";
            
$stmt_prof = $conn->prepare($sql_prof);
$stmt_prof->bind_param("ii", $id_professor_url, $id_escola_sessao);
$stmt_prof->execute();
$result_prof = $stmt_prof->get_result();

// Verificação robusta do resultado com MENSAGEM DE ERRO DETALHADA
if ($result_prof->num_rows !== 1) {
    die("Erro crítico: A consulta do professor falhou. A consulta retornou " . $result_prof->num_rows . " linhas. Erro do statement: " . htmlspecialchars($stmt_prof->error));
}
$dados_prof_escola = $result_prof->fetch_assoc();

// ... O restante do código continua igual ...

// Busca o modelo de contrato
$sql_modelo = "SELECT conteudo FROM modelos_contrato WHERE id = ?";
$stmt_modelo = $conn->prepare($sql_modelo);
$stmt_modelo->bind_param("i", $id_modelo_url);
$stmt_modelo->execute();
$modelo = $stmt_modelo->get_result()->fetch_assoc();
if (!$modelo) {
    die("Modelo de contrato não encontrado.");
}
$conn->close();

require('fpdf.php');

// ... (resto do código para preparar os placeholders e o texto final) ...
setlocale(LC_TIME, 'pt_BR.UTF-8', 'pt_BR', 'portuguese');
date_default_timezone_set('America/Sao_Paulo');
$placeholders = [
    '[NOME_PROFESSOR]'          => $dados_prof_escola['prof_nome'],
    // ... todos os outros placeholders ...
    '[CIDADE_ESCOLA]'           => $dados_prof_escola['escola_cidade']
];
$texto_contrato = $modelo['conteudo'];
$texto_final = str_replace(array_keys($placeholders), array_values($placeholders), $texto_contrato);

class PDF extends FPDF {
    function Header() {
        if (file_exists('logo.png')) $this->Image('logo.png', 10, 6, 40);
        $this->SetFont('Arial', 'B', 12);
        $this->Cell(0, 10, utf8_decode('CONTRATO PARTICULAR DE PRESTAÇÃO DE SERVIÇOS DE TRABALHO AUTÔNOMO'), 0, 1, 'C');
        $this->Ln(5);
    }
    function Footer() {
        $this->SetY(-15);
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(0, 5, utf8_decode('Data de emissão: ' . date('d/m/Y')), 0, 1, 'L');
        $this->Cell(0, 5, utf8_decode('Página ') . $this->PageNo() . '/{nb}', 0, 0, 'R');
    }
}

if (ob_get_length()) ob_end_clean();

$pdf = new PDF();
$pdf->AliasNbPages();
$pdf->AddPage();
$pdf->SetFont('Arial', '', 11);
$pdf->MultiCell(0, 6, utf8_decode($texto_final));
$pdf->Output("I", "Contrato.pdf");
exit;
?>