<?php

// =================================================================
// BLOCO DE INÍCIO PADRÃO
// =================================================================
include 'verifica_login.php';
include 'conexao.php';
$id_escola = $_SESSION['id_escola'];
$nome_usuario = $_SESSION['usuario_nome'];
$nivel_usuario = $_SESSION['usuario_nivel'];
// =================================================================

$mensagem_sucesso = '';
$mensagem_erro = '';

function br_to_float($v) {
    $v = trim((string)$v);
    if ($v === '') return 0.0;
    $v = str_replace('.', '', $v);
    $v = str_replace(',', '.', $v);
    return (float)$v;
}

// LÓGICA DE SALVAMENTO ADAPTADA DO SEU FICHEIRO FUNCIONAL
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $aluno_nome         = trim($_POST['aluno_nome'] ?? '');
    $curso_id           = (int)($_POST['curso_id'] ?? 0);
    $parcelas_contrato  = (int)($_POST['num_parcelas'] ?? 0);
    $valor_parcela      = br_to_float($_POST['valor_parcela'] ?? 0);
    $aulas_estudadas    = (int)($_POST['aulas_estudadas'] ?? 0);
    $duracao_aula       = br_to_float($_POST['duracao_aula'] ?? 0);
    $total_pago         = br_to_float($_POST['total_pago'] ?? 0);
    $percentual_multa   = br_to_float($_POST['perc_multa'] ?? 10);
    $historico_conversa = trim($_POST['historico_conversa'] ?? '');
    
    $stmt_curso = $conn->prepare("SELECT horas_total FROM cursos WHERE id = ? AND id_escola = ?");
    $stmt_curso->bind_param("ii", $curso_id, $id_escola);
    $stmt_curso->execute();
    $curso_data = $stmt_curso->get_result()->fetch_assoc();
    $horas_total_curso = $curso_data['horas_total'] ?? 0;

    $valor_total_curso   = $parcelas_contrato * $valor_parcela;
    $valor_hora_aula     = ($horas_total_curso > 0) ? ($valor_total_curso / $horas_total_curso) : 0;
    $horas_estudadas     = $aulas_estudadas * $duracao_aula;
    $valor_estudado_sala = $horas_estudadas * $valor_hora_aula;
    $debito_credito      = $valor_estudado_sala - $total_pago;
    $valor_multa         = ($percentual_multa / 100.0) * $valor_total_curso; // Multa sobre o valor total, como no seu script
    $valor_total_a_pagar = $debito_credito + $valor_multa;

    $sql = "INSERT INTO cancelamentos 
        (id_escola, aluno_nome, curso_id, parcelas_contrato, valor_parcela, valor_hora_aula, aulas_estudadas, 
        duracao_aula, horas_estudadas, valor_estudado_sala, parcelas_pagas, valor_a_pagar_escola, 
        percentual_multa, valor_total_curso, valor_multa, valor_total_a_pagar, historico_conversa) 
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    
    $stmt = $conn->prepare($sql);
    
    $stmt->bind_param("isiididddddddddds",
        $id_escola, $aluno_nome, $curso_id, $parcelas_contrato, $valor_parcela, $valor_hora_aula, $aulas_estudadas,
        $duracao_aula, $horas_estudadas, $valor_estudado_sala, $total_pago, $debito_credito,
        $percentual_multa, $valor_total_curso, $valor_multa, $valor_total_a_pagar, $historico_conversa
    );

    if ($stmt->execute()) {
        $mensagem_sucesso = "Cancelamento registado com sucesso!";
    } else {
        $mensagem_erro = "Erro ao salvar: " . $stmt->error;
    }
}

// Buscar cursos da escola logada para o dropdown
$cursos_res = $conn->prepare("SELECT id, nome, horas_total FROM cursos WHERE id_escola = ? ORDER BY nome");
$cursos_res->bind_param("i", $id_escola);
$cursos_res->execute();
$cursos = $cursos_res->get_result();
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8">
<title>Calculadora de Cancelamento</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="style.css">
<style>
    .calculator-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 20px; }
    .panel h2 { font-size: 16px; color: var(--accent-color); margin: 0 0 16px; padding-bottom: 8px; border-bottom: 2px solid var(--accent-color); }
    .input-group { display: grid; grid-template-columns: 1fr 1fr; gap: 16px; }
    .output-group { background-color: #f9fafb; padding: 12px; border-radius: 10px; margin-bottom: 16px; }
    .output-group h3 { font-size: 14px; margin: 0 0 8px; color: var(--muted-text); }
    .output-item { display: flex; justify-content: space-between; align-items: center; padding: 8px 0; border-bottom: 1px solid var(--border-color); }
    .output-item:last-child { border-bottom: none; }
    .output-item .label { font-size: 14px; color: var(--muted-text); position: relative; }
    .output-item .value { font-size: 16px; font-weight: 600; }
    .total-card .value { font-size: 28px; font-weight: 700; color: var(--danger-color); }
    .has-tooltip { cursor: help; border-bottom: 1px dotted #9ca3af; }
    .tooltip-text { visibility: hidden; width: 240px; background-color: #333; color: #fff; text-align: center; border-radius: 6px; padding: 8px; position: absolute; z-index: 1; bottom: 110%; left: 50%; transform: translateX(-50%); opacity: 0; transition: opacity 0.3s; font-size: 12px; }
    .has-tooltip:hover .tooltip-text { visibility: visible; opacity: 1; }
    @media (max-width: 900px) { .calculator-grid { grid-template-columns: 1fr; } }
</style>
</head>
<body>

<div class="app-container">
    <?php include 'menu.php'; ?>
    <main class="main-content">
        <h1>Calculadora de Cancelamento</h1>
        <?php if ($mensagem_sucesso): ?><div class="msg ok"><?= htmlspecialchars($mensagem_sucesso) ?></div><?php endif; ?>
        <?php if ($mensagem_erro): ?><div class="msg err"><?= htmlspecialchars($mensagem_erro) ?></div><?php endif; ?>
        
        <form method="post" id="form-cancel">
            <div class="calculator-grid">
                <div class="input-panel">
                    <div class="card">
                        <h2>Dados do Contrato</h2>
                        <div class="input-group">
                            <div style="grid-column: 1 / -1;"><label>Nome do Aluno</label><input type="text" name="aluno_nome" required></div>
                            <div style="grid-column: 1 / -1;">
                                <label>Curso</label>
                                <select name="curso_id" id="curso_id" required>
                                    <option value="" data-horas="0">Selecione o curso</option>
                                    <?php while ($c = $cursos->fetch_assoc()): ?>
                                    <option value="<?= (int)$c['id'] ?>" data-horas="<?= htmlspecialchars($c['horas_total']) ?>"><?= htmlspecialchars($c['nome']) ?> (<?= htmlspecialchars(number_format($c['horas_total'], 0)) ?>h)</option>
                                    <?php endwhile; ?>
                                </select>
                            </div>
                            <div><label>Nº de Parcelas</label><input type="number" name="num_parcelas" id="num_parcelas" value="0" min="0"></div>
                            <div><label>Valor da Parcela (R$)</label><input type="text" name="valor_parcela" id="valor_parcela" inputmode="decimal"></div>
                        </div>
                    </div>
                    <div class="card">
                        <h2>Horas Estudadas</h2>
                        <div class="input-group">
                            <div><label>Total de Aulas Estudadas</label><input type="number" name="aulas_estudadas" id="aulas_estudadas" value="0" min="0"></div>
                            <div><label>Duração da Aula (hrs)</label><input type="text" name="duracao_aula" id="duracao_aula" inputmode="decimal" value="1.0"></div>
                        </div>
                    </div>
                    <div class="card">
                        <h2>Valores</h2>
                        <div class="input-group">
                            <div><label>Total Pago pelo Aluno (R$)</label><input type="text" name="total_pago" id="total_pago" inputmode="decimal"></div>
                            <div><label>% Multa Contratual</label><input type="number" name="perc_multa" id="perc_multa" value="10" min="0"></div>
                        </div>
                    </div>
                </div>
                <div class="output-panel">
                    <div class="card">
                        <h2>Resultados do Cálculo</h2>
                        <div class="output-group">
                            <h3>Contrato</h3>
                            <div class="output-item"><span class="label has-tooltip">Valor total do curso<span class="tooltip-text">Nº de Parcelas × Valor da Parcela</span></span><span class="value" id="res_valor_total_curso">R$ 0,00</span></div>
                            <div class="output-item"><span class="label">Carga Horária Total</span><span class="value" id="res_carga_horaria">0h</span></div>
                            <div class="output-item"><span class="label has-tooltip">Valor Hora/Aula<span class="tooltip-text">Valor Total do Curso ÷ Carga Horária Total</span></span><span class="value" id="res_valor_hora_aula">R$ 0,00</span></div>
                        </div>
                        <div class="output-group">
                            <h3>Horas Aula</h3>
                            <div class="output-item"><span class="label has-tooltip">Total de Horas Estudadas<span class="tooltip-text">Aulas Estudadas × Duração da Aula</span></span><span class="value" id="res_total_horas_estudadas">0h</span></div>
                            <div class="output-item"><span class="label has-tooltip">Valor Estudado em Sala<span class="tooltip-text">Total de Horas Estudadas × Valor Hora/Aula</span></span><span class="value" id="res_valor_estudado">R$ 0,00</span></div>
                        </div>
                        <div class="output-group">
                            <h3>Valores</h3>
                            <div class="output-item"><span class="label has-tooltip">Débito/Crédito do Aluno<span class="tooltip-text">Valor Estudado - Total Pago</span></span><span class="value" id="res_debito_credito">R$ 0,00</span></div>
                            <div class="output-item"><span class="label has-tooltip">Valor da Multa<span class="tooltip-text">% Multa × Valor Total do Curso</span></span><span class="value" id="res_valor_multa">R$ 0,00</span></div>
                        </div>
                    </div>
                    <div class="card total-card">
                        <span class="label has-tooltip" id="res_total_label">TOTAL A PAGAR</span><span class="tooltip-text">Débito/Crédito do Aluno + Valor da Multa</span>
                        <div class="value" id="res_total_a_pagar">R$ 0,00</div>
                    </div>
                </div>
            </div>
            <div class="card">
                <h2>Histórico da Conversa</h2>
                <textarea name="historico_conversa" rows="4" placeholder="Anote aqui os detalhes da negociação, motivos, etc."></textarea>
            </div>
            <div class="actions" style="text-align: right;">
                <button type="submit" class="btn primary">Salvar Cancelamento</button>
            </div>
        </form>
        <?php include 'footer.php'; ?>
    </main>
</div>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const brToFloat = (v) => {
        v = (v || '').toString().trim().replace(/\./g, '').replace(',', '.');
        return parseFloat(v) || 0;
    };
    const floatToBR = (n) => (n || 0).toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
    
    const elements = {
        cursoSelect: document.getElementById('curso_id'),
        numParcelas: document.getElementById('num_parcelas'),
        valorParcela: document.getElementById('valor_parcela'),
        aulasEstudadas: document.getElementById('aulas_estudadas'),
        duracaoAula: document.getElementById('duracao_aula'),
        totalPago: document.getElementById('total_pago'),
        percMulta: document.getElementById('perc_multa'),
        resCargaHoraria: document.getElementById('res_carga_horaria'),
        resValorTotalCurso: document.getElementById('res_valor_total_curso'),
        resValorHoraAula: document.getElementById('res_valor_hora_aula'),
        resTotalHorasEstudadas: document.getElementById('res_total_horas_estudadas'),
        resValorEstudado: document.getElementById('res_valor_estudado'),
        resDebitoCredito: document.getElementById('res_debito_credito'),
        resValorMulta: document.getElementById('res_valor_multa'),
        resTotalAPagar: document.getElementById('res_total_a_pagar'),
        resTotalLabel: document.getElementById('res_total_label')
    };

    function calcularTudo() {
        const cargaHorariaTotal = parseFloat(elements.cursoSelect.options[elements.cursoSelect.selectedIndex]?.dataset.horas || 0);
        const numParcelas = parseInt(elements.numParcelas.value, 10) || 0;
        const valorParcela = brToFloat(elements.valorParcela.value);
        const aulasEstudadas = parseInt(elements.aulasEstudadas.value, 10) || 0;
        const duracaoAula = brToFloat(elements.duracaoAula.value);
        const totalPago = brToFloat(elements.totalPago.value);
        const percMulta = parseInt(elements.percMulta.value, 10) || 0;

        const valorTotalCurso = numParcelas * valorParcela;
        const valorHoraAula = cargaHorariaTotal > 0 ? valorTotalCurso / cargaHorariaTotal : 0;
        const totalHorasEstudadas = aulasEstudadas * duracaoAula;
        const valorEstudado = totalHorasEstudadas * valorHoraAula;
        const debitoCredito = valorEstudado - totalPago;
        const valorMulta = (percMulta / 100) * valorTotalCurso; // Multa sobre o valor total do curso
        const totalFinal = debitoCredito + valorMulta; // Soma direta
        
        elements.resCargaHoraria.textContent = cargaHorariaTotal.toFixed(0) + 'h';
        elements.resValorTotalCurso.textContent = 'R$ ' + floatToBR(valorTotalCurso);
        elements.resValorHoraAula.textContent = 'R$ ' + floatToBR(valorHoraAula);
        elements.resTotalHorasEstudadas.textContent = totalHorasEstudadas.toFixed(1).replace('.', ',') + 'h';
        elements.resValorEstudado.textContent = 'R$ ' + floatToBR(valorEstudado);
        elements.resDebitoCredito.textContent = 'R$ ' + floatToBR(debitoCredito);
        elements.resValorMulta.textContent = 'R$ ' + floatToBR(valorMulta);
        
        elements.resTotalAPagar.style.color = '';
        if (totalFinal < 0) {
            elements.resTotalLabel.textContent = 'VALOR A DEVOLVER AO ALUNO';
            elements.resTotalAPagar.textContent = 'R$ ' + floatToBR(Math.abs(totalFinal));
            elements.resTotalAPagar.style.color = 'var(--success-color)';
        } else {
            elements.resTotalLabel.textContent = 'TOTAL A PAGAR PELO ALUNO';
            elements.resTotalAPagar.textContent = 'R$ ' + floatToBR(totalFinal);
            elements.resTotalAPagar.style.color = 'var(--danger-color)';
        }
    }

    const inputs = [elements.cursoSelect, elements.numParcelas, elements.valorParcela, elements.aulasEstudadas, elements.duracaoAula, elements.totalPago, elements.percMulta];
    inputs.forEach(input => {
        if (input) {
            input.addEventListener('input', calcularTudo);
            input.addEventListener('change', calcularTudo);
        }
    });

    calcularTudo();
});
</script>
</body>
</html>