<?php
// =================================================================
// BLOCO DE INÍCIO PADRÃO (VERSÃO FINAL)
// =================================================================
include 'verifica_login.php';
include 'conexao.php';
$id_escola = $_SESSION['id_escola'];
$nome_usuario = $_SESSION['usuario_nome'];
$nivel_usuario = $_SESSION['usuario_nivel'];
// =================================================================

$mensagem_sucesso = '';
$mensagem_erro = '';

// Se o formulário foi enviado
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // A lógica do POST já estava correta e segura, mantemos como está
    $nome            = $_POST['nome'] ?? '';
    $cpf             = $_POST['cpf'] ?? '';
    // ... e as outras variáveis ...
    $rg              = $_POST['rg'] ?? '';
    $telefone        = $_POST['telefone'] ?? '';
    $nome_curso      = $_POST['nome_curso'] ?? '';
    $area_curso      = $_POST['area_curso'] ?? '';
    $pix             = $_POST['pix'] ?? '';
    $banco           = $_POST['banco'] ?? '';
    $observacoes     = $_POST['observacoes'] ?? '';
    $data_admissao   = $_POST['data_admissao'] ?: null;
    $data_demissao   = $_POST['data_demissao'] ?: null;
    $ajuda_custo     = $_POST['ajuda_custo'] ? (float)str_replace(',', '.', $_POST['ajuda_custo']) : 0.0;
    $valor_hora_aula = $_POST['valor_hora_aula'] ? (float)str_replace(',', '.', $_POST['valor_hora_aula']) : 0.0;
    $dia_pagamento   = $_POST['dia_pagamento'] ?? '';
    $endereco        = $_POST['endereco'] ?? '';
    $estado_civil    = $_POST['estado_civil'] ?? '';

    $sql = "INSERT INTO professores (id_escola, nome, cpf, rg, telefone, nome_curso, area_curso, pix, banco, observacoes, data_admissao, data_demissao, ajuda_custo, valor_hora_aula, dia_pagamento, endereco, estado_civil) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

    $stmt = $conn->prepare($sql);
    
    $stmt->bind_param("issssssssssssdsss", $id_escola, $nome, $cpf, $rg, $telefone, $nome_curso, $area_curso, $pix, $banco, $observacoes, $data_admissao, $data_demissao, $ajuda_custo, $valor_hora_aula, $dia_pagamento, $endereco, $estado_civil);

    if ($stmt->execute()) {
        $mensagem_sucesso = "Professor cadastrado com sucesso!";
    } else {
        $mensagem_erro = "Erro ao cadastrar: " . $stmt->error;
    }
}

// CORREÇÃO: Buscar cursos e suas áreas com JOIN
$cursos_result = $conn->query("SELECT c.nome, a.nome AS area_nome FROM cursos c JOIN areas_curso a ON c.area_curso_id = a.id WHERE c.id_escola = $id_escola ORDER BY c.nome ASC");

?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8">
<title>Cadastro de Professor</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<style>
/* Estilo 'Dashboard' inspirado nos seus outros arquivos */
:root {
    --bg: #f6f8fb; --card: #fff; --muted: #64748b; --text: #0f172a;
    --accent: #4f46e5; --ok: #10b981; --bad: #ef4444; --border: #e5e7eb;
}
* { box-sizing: border-box; }
body { font-family: Inter, Segoe UI, Roboto, Arial, sans-serif; background: var(--bg); color: var(--text); margin: 0; }
.container { max-width: 980px; margin: 24px auto; padding: 16px; }
h1 { font-size: 22px; margin: 0 0 12px; }
.card { background: var(--card); border: 1px solid var(--border); border-radius: 14px; padding: 20px; box-shadow: 0 10px 30px rgba(15,23,42,.04); margin-bottom: 14px; }
.grid { display: grid; grid-template-columns: repeat(12, 1fr); gap: 16px; }
.col-12 { grid-column: span 12; } .col-6 { grid-column: span 6; } .col-4 { grid-column: span 4; }
label { font-size: 13px; color: var(--muted); display: block; margin-bottom: 6px; font-weight: 500; }
input, select, textarea { width: 100%; padding: 10px 12px; border: 1px solid var(--border); border-radius: 10px; font-size: 14px; background: #fff; }
textarea { min-height: 80px; }
.btn { border: none; border-radius: 10px; padding: 12px 20px; cursor: pointer; font-weight: 600; font-size: 14px; }
.btn.primary { background: var(--accent); color: #fff; }
.msg { padding: 12px 16px; border-radius: 10px; margin-bottom: 16px; font-weight: 500; }
.msg.ok { background: #ecfdf5; color: #065f46; border: 1px solid #a7f3d0; }
.msg.err { background: #fef2f2; color: #991b1b; border: 1px solid #fecaca; }
@media (max-width: 760px) { .col-6, .col-4 { grid-column: span 12; } }
</style>
</head>
<body>

<div class="app-container">
    <?php include 'menu.php'; ?>

    <main class="main-content">
        <br></br>
        <br></br>
        <h1>Cadastro de Professor</h1>

        <?php if ($mensagem_sucesso): ?><div class="msg ok"><?= htmlspecialchars($mensagem_sucesso) ?></div><?php endif; ?>
        <?php if ($mensagem_erro): ?><div class="msg err"><?= htmlspecialchars($mensagem_erro) ?></div><?php endif; ?>

        <form method="post">
            <div class="card">
                <div class="grid">
                    <div class="col-12"><label>Nome Completo</label><input type="text" name="nome" required></div>
                    <div class="col-4"><label>CPF</label><input type="text" name="cpf"></div>
                    <div class="col-4"><label>RG</label><input type="text" name="rg"></div>
                    <div class="col-4"><label>Estado Civil</label><input type="text" name="estado_civil"></div>
                    <div class="col-6"><label>Telefone</label><input type="text" name="telefone"></div>
                    <div class="col-6"><label>Endereço</label><input type="text" name="endereco"></div>
                </div>
            </div>

            <div class="card">
                 <div class="grid">
                    <div class="col-6"><label>Curso Principal</label>
                        <select name="nome_curso" id="nome_curso" onchange="atualizarAreaCurso()" required>
                            <option value="">Selecione um curso</option>
                            <?php 
                            if ($cursos_result) {
                                while($curso = $cursos_result->fetch_assoc()): 
                            ?>
                                    <option value="<?= htmlspecialchars($curso['nome']) ?>" data-area="<?= htmlspecialchars($curso['area_nome']) ?>">
                                        <?= htmlspecialchars($curso['nome']) ?>
                                    </option>
                            <?php 
                                endwhile; 
                            }
                            ?>
                        </select>
                    </div>
                    <div class="col-6"><label>Área do Curso</label><input type="text" name="area_curso" id="area_curso" readonly style="background:#eef2f7;"></div>
                    <div class="col-6"><label>Data de Admissão</label><input type="date" name="data_admissao"></div>
                    <div class="col-6"><label>Data de Demissão</label><input type="date" name="data_demissao"></div>
                </div>
            </div>

            <div class="card">
                <div class="grid">
                    <div class="col-4"><label>Valor Hora/Aula (R$)</label><input type="text" inputmode="decimal" name="valor_hora_aula" placeholder="ex: 25,50"></div>
                    <div class="col-4"><label>Ajuda de Custo (R$)</label><input type="text" inputmode="decimal" name="ajuda_custo" placeholder="ex: 150,00"></div>
                    <div class="col-4"><label>Dia de Pagamento</label><input type="text" name="dia_pagamento" placeholder="ex: 5º dia útil"></div>
                    <div class="col-6"><label>PIX</label><input type="text" name="pix"></div>
                    <div class="col-6"><label>Banco</label><input type="text" name="banco"></div>
                </div>
            </div>

            <div class="card">
                <label>Observações</label>
                <textarea name="observacoes"></textarea>
            </div>

            <div style="text-align: right;">
                <button type="submit" class="btn primary">Salvar Professor</button>
            </div>
        </form>
        <br></br>
        <?php include 'footer.php'; ?>
    </main>
</div>

<script>
function atualizarAreaCurso() {
    const selectCurso = document.getElementById("nome_curso");
    if (selectCurso.selectedIndex > 0) {
        const optionSelecionada = selectCurso.options[selectCurso.selectedIndex];
        const areaCurso = optionSelecionada.getAttribute("data-area");
        document.getElementById("area_curso").value = areaCurso || "";
    } else {
        document.getElementById("area_curso").value = "";
    }
}
</script>

</body>
</html>