<?php
// =================================================================
// BLOCO DE INÍCIO PADRÃO
// =================================================================
include 'verifica_login.php';
include 'conexao.php';
$id_escola_logada = $_SESSION['id_escola'];
$nome_usuario_logado = $_SESSION['usuario_nome'];
$nivel_usuario_logado = $_SESSION['usuario_nivel'];
// =================================================================

$mensagem = '';
$area_para_editar = null;

// Lógica para Deletar
if (isset($_GET['excluir_id'])) {
    $id_para_excluir = (int)$_GET['excluir_id'];
    $stmt = $conn->prepare("DELETE FROM areas_curso WHERE id = ?");
    $stmt->bind_param("i", $id_para_excluir);
    if ($stmt->execute()) {
        $mensagem = "Área excluída com sucesso!";
    } else {
        $mensagem = "Erro ao excluir a área. Verifique se ela não está em uso.";
    }
}

// Lógica para Adicionar ou Atualizar
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nome_area = trim($_POST['nome_area']);
    $id_area_editada = (int)($_POST['id_area_editada'] ?? 0);

    if (!empty($nome_area)) {
        if ($id_area_editada > 0) { // Atualizar
            $stmt = $conn->prepare("UPDATE areas_curso SET nome = ? WHERE id = ?");
            $stmt->bind_param("si", $nome_area, $id_area_editada);
            $mensagem = "Área atualizada com sucesso!";
        } else { // Inserir
            $stmt = $conn->prepare("INSERT INTO areas_curso (nome) VALUES (?)");
            $stmt->bind_param("s", $nome_area);
            $mensagem = "Área adicionada com sucesso!";
        }
        $stmt->execute();
    }
}

// Lógica para carregar uma área para edição
if (isset($_GET['editar_id'])) {
    $id_para_editar = (int)$_GET['editar_id'];
    $stmt = $conn->prepare("SELECT * FROM areas_curso WHERE id = ?");
    $stmt->bind_param("i", $id_para_editar);
    $stmt->execute();
    $area_para_editar = $stmt->get_result()->fetch_assoc();
}

// Buscar todas as áreas para listar
$areas = $conn->query("SELECT * FROM areas_curso ORDER BY nome ASC");
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8">
<title>Gerenciar Áreas de Curso</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<style>
/* Estilo 'Dashboard' Padrão */
:root {
    --bg: #f6f8fb; --card: #fff; --muted: #64748b; --text: #0f172a;
    --accent: #4f46e5; --ok: #10b981; --bad: #ef4444; --border: #e5e7eb;
}
* { box-sizing: border-box; }
body { font-family: Inter, Segoe UI, Roboto, Arial, sans-serif; background: var(--bg); color: var(--text); margin: 0; }
.container { max-width: 1000px; margin: 24px auto; padding: 16px; }
h1 { font-size: 22px; margin: 0; }
.card { background: var(--card); border: 1px solid var(--border); border-radius: 14px; padding: 20px; box-shadow: 0 10px 30px rgba(15,23,42,.04); }
.header-actions { display: flex; justify-content: space-between; align-items: center; margin-bottom: 16px; }
.btn { border: none; border-radius: 10px; padding: 12px 20px; cursor: pointer; font-weight: 600; font-size: 14px; text-decoration: none; display: inline-block; text-align: center; }
.btn.primary { background: var(--accent); color: #fff; }
/* Tabela */
table { width: 100%; border-collapse: collapse; margin-top: 10px; }
th, td { padding: 12px 16px; text-align: left; border-bottom: 1px solid var(--border); }
th { font-size: 12px; color: var(--muted); text-transform: uppercase; }
td { color: #334155; }
.actions-cell a { margin-right: 10px; font-size: 13px; text-decoration: none; color: var(--accent); font-weight: 500; }
.actions-cell a.delete { color: var(--bad); }
.total-count { margin-top: 16px; font-weight: 500; color: var(--muted); }
</style>
</head>
<body>
<div class="app-container">
    <?php include 'menu.php'; ?>
    <main class="main-content">
        <h1>Gerenciar Áreas de Curso</h1>
        
        <?php if($mensagem): ?>
            <div class="msg ok" style="margin-bottom: 16px;"><?= htmlspecialchars($mensagem) ?></div>
        <?php endif; ?>

        <div class="card">
            <h2><?= $area_para_editar ? 'Editar Área' : 'Adicionar Nova Área' ?></h2>
            <form method="post" action="areas_curso.php">
                <input type="hidden" name="id_area_editada" value="<?= $area_para_editar['id'] ?? 0 ?>">
                <label for="nome_area">Nome da Área</label>
                <input type="text" id="nome_area" name="nome_area" value="<?= htmlspecialchars($area_para_editar['nome'] ?? '') ?>" required>
                <div class="actions" style="text-align: right; margin-top: 10px;">
                    <?php if($area_para_editar): ?>
                        <a href="areas_curso.php" class="btn ghost">Cancelar Edição</a>
                    <?php endif; ?>
                    <button type="submit" class="btn primary"><?= $area_para_editar ? 'Salvar Alterações' : 'Adicionar Área' ?></button>
                </div>
            </form>
        </div>

        <div class="card">
            <h2>Áreas Existentes</h2>
            <table>
                <thead><tr><th>Nome da Área</th><th>Ações</th></tr></thead>
                <tbody>
                    <?php while($area = $areas->fetch_assoc()): ?>
                    <tr>
                        <td><?= htmlspecialchars($area['nome']) ?></td>
                        <td class="actions-cell">
                            <a href="areas_curso.php?editar_id=<?= $area['id'] ?>">Editar</a>
                            <a href="areas_curso.php?excluir_id=<?= $area['id'] ?>" class="delete" onclick="return confirm('Tem certeza que deseja excluir esta área?')">Excluir</a>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
        
        <?php include 'footer.php'; ?>
    </main>
</div>
</body>
</html>