<?php
// =================================================================
// BLOCO DE INÍCIO PADRÃO
// =================================================================
include 'verifica_login.php';
include 'conexao.php';
$id_escola = $_SESSION['id_escola'];
//...
// =================================================================

$mensagem_sucesso = '';
$mensagem_erro = '';

// Lógica do POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nome = $_POST['nome'] ?? '';
    $area_curso_id = (int)($_POST['area_curso_id'] ?? 0);
    $horas_total = $_POST['horas_total'] ? (float)str_replace(',', '.', $_POST['horas_total']) : 0.0;

    if (empty($nome) || $area_curso_id <= 0) {
        $mensagem_erro = "O nome e a área do curso são obrigatórios.";
    } else {
        $sql = "INSERT INTO cursos (id_escola, nome, area_curso_id, horas_total) VALUES (?, ?, ?, ?)";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("isid", $id_escola, $nome, $area_curso_id, $horas_total);
        if ($stmt->execute()) {
            $mensagem_sucesso = "Curso '".htmlspecialchars($nome)."' cadastrado com sucesso!";
        } else {
            $mensagem_erro = "Erro ao cadastrar o curso: " . $stmt->error;
        }
    }
}

// Buscar áreas para o dropdown
$areas = $conn->query("SELECT * FROM areas_curso ORDER BY nome ASC");
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8">
<title>Adicionar Novo Curso</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<style>
/* Estilo 'Dashboard' Padrão */
:root {
    --bg: #f6f8fb; --card: #fff; --muted: #64748b; --text: #0f172a;
    --accent: #4f46e5; --ok: #10b981; --bad: #ef4444; --border: #e5e7eb;
}
* { box-sizing: border-box; }
body { font-family: Inter, Segoe UI, Roboto, Arial, sans-serif; background: var(--bg); color: var(--text); margin: 0; }
.container { max-width: 800px; margin: 24px auto; padding: 16px; }
h1 { font-size: 22px; margin: 0 0 12px; }
.card { background: var(--card); border: 1px solid var(--border); border-radius: 14px; padding: 20px; box-shadow: 0 10px 30px rgba(15,23,42,.04); }
.grid { display: grid; grid-template-columns: 1fr; gap: 16px; }
@media (min-width: 768px) { .grid { grid-template-columns: repeat(3, 1fr); } }
label { font-size: 13px; color: var(--muted); display: block; margin-bottom: 6px; font-weight: 500; }
input { width: 100%; padding: 10px 12px; border: 1px solid var(--border); border-radius: 10px; font-size: 14px; background: #fff; }
.btn { border: none; border-radius: 10px; padding: 12px 20px; cursor: pointer; font-weight: 600; font-size: 14px; }
.btn.primary { background: var(--accent); color: #fff; }
.actions { text-align: right; margin-top: 20px; }
.msg { padding: 12px 16px; border-radius: 10px; margin-bottom: 16px; font-weight: 500; }
.msg.ok { background: #ecfdf5; color: #065f46; border: 1px solid #a7f3d0; }
.msg.err { background: #fef2f2; color: #991b1b; border: 1px solid #fecaca; }
.full-width { grid-column: 1 / -1; }
</style>
</head>
<body>
<div class="app-container">
    <?php include 'menu.php'; ?>
    <main class="main-content">
        <br></br>
        <br></br>
        <h1>Adicionar Novo Curso</h1>
        
        <?php if ($mensagem_sucesso): ?><div class="msg ok"><?= $mensagem_sucesso ?></div><?php endif; ?>
        <?php if ($mensagem_erro): ?><div class="msg err"><?= $mensagem_erro ?></div><?php endif; ?>

        <div class="card">
            <form method="post">
                <div class="grid">
                    <div class="full-width">
                        <label for="nome">Nome do Curso</label>
                        <input type="text" id="nome" name="nome" required>
                    </div>

                     <div>
                        <label for="area_curso_id">Área do Curso</label>
                        <select id="area_curso_id" name="area_curso_id" required>
                            <option value="">Selecione...</option>
                            <?php while($area = $areas->fetch_assoc()): ?>
                                <option value="<?= $area['id'] ?>"><?= htmlspecialchars($area['nome']) ?></option>
                            <?php endwhile; ?>
                        </select>
                    </div>

                    <div>
                        <label for="horas_total">Carga Horária Total</label>
                        <input type="text" id="horas_total" name="horas_total" inputmode="decimal" placeholder="Ex: 80,5">
                    </div>

                </div>

                <div class="actions" style="text-align:right; margin-top:20px;">
                    <button type="submit" class="btn primary">Salvar Curso</button>
                </div>
            </form>
        </div>
        <?php include 'footer.php'; ?>
    </main>
</div>
</body>
</html>