# Prática Tecnologias - Website

Site institucional moderno e responsivo para a empresa Prática Tecnologias, especializada em sistemas práticos para empresas e desenvolvimento sob demanda.

## 🚀 Características

- **Design Moderno**: Interface elegante com cores tecnológicas (azul, ciano, roxo)
- **Totalmente Responsivo**: Otimizado para desktop, tablet e mobile
- **Performance Otimizada**: Carregamento rápido e animações suaves
- **SEO Friendly**: Estrutura semântica e meta tags otimizadas
- **Formulário Funcional**: Sistema de contato em PHP com validação
- **PWA Ready**: Service Worker para funcionalidade offline

## 📁 Estrutura do Projeto

```
/
├── index.html              # Página principal
├── contact.php            # Processador do formulário de contato
├── sw.js                  # Service Worker para PWA
├── README.md              # Documentação
└── assets/
    ├── css/
    │   ├── style.css      # Estilos principais
    │   └── responsive.css # Estilos responsivos
    └── js/
        └── main.js        # JavaScript principal
```

## 🛠️ Tecnologias Utilizadas

- **HTML5**: Estrutura semântica
- **CSS3**: Estilos modernos com Flexbox e Grid
- **JavaScript ES6+**: Interatividade e animações
- **PHP**: Processamento do formulário de contato
- **Font Awesome**: Ícones vetoriais
- **Google Fonts**: Tipografia (Inter)

## 🎨 Recursos de Design

- Gradientes tecnológicos (azul → ciano → roxo)
- Animações suaves ao scroll
- Efeitos hover sofisticados
- Elementos flutuantes com parallax
- Micro-interações elegantes
- Sistema de notificações

## 📱 Responsividade

- **Desktop**: 1200px+
- **Tablet**: 768px - 1199px
- **Mobile**: 320px - 767px
- **Breakpoints customizados** para diferentes dispositivos

## ⚡ Funcionalidades

### Navegação
- Menu responsivo com hamburger mobile
- Scroll suave entre seções
- Indicador de seção ativa
- Header com efeito de transparência

### Seções
- **Hero**: Banner principal com call-to-action
- **Sobre**: Apresentação da empresa com estatísticas
- **Serviços**: Grid de serviços com ícones
- **Portfólio**: Galeria de projetos com overlay
- **Instagram**: Chamada para redes sociais
- **Contato**: Formulário funcional e informações

### Interatividade
- Animações ao scroll (Intersection Observer)
- Formulário com validação em tempo real
- Botão flutuante do WhatsApp
- Botão "Voltar ao topo"
- Sistema de notificações

## 🔧 Configuração

### Requisitos
- Servidor web (Apache/Nginx)
- PHP 7.4+ (para formulário de contato)
- HTTPS recomendado (para PWA)

### Instalação
1. Faça upload dos arquivos para seu servidor
2. Configure as permissões adequadas
3. Edite `contact.php` com suas configurações de e-mail
4. Teste o formulário de contato

### Configuração do E-mail
Edite as configurações em `contact.php`:

```php
$config = [
    'to_email' => 'seu-email@praticatecnologias.com.br',
    'from_email' => 'noreply@praticatecnologias.com.br',
    // ... outras configurações
];
```

## 🔒 Segurança

- Validação e sanitização de dados
- Proteção contra spam
- Rate limiting por IP
- Headers de segurança
- Escape de HTML

## 📊 Performance

- CSS e JS minificados em produção
- Lazy loading de imagens
- Service Worker para cache
- Otimização de fontes
- Compressão de assets

## 🎯 SEO

- Meta tags otimizadas
- Structured Data (JSON-LD)
- Open Graph tags
- URLs semânticas
- Sitemap XML

## 📞 Contato

- **WhatsApp**: +55 51 99766-1588
- **E-mail**: contato@praticatecnologias.com.br
- **Instagram**: @praticatecnologias
- **Site**: https://praticatecnologias.com.br

## 📄 Licença

© 2025 Prática Tecnologias. Todos os direitos reservados.

---

Desenvolvido com ❤️ para transformar negócios através da tecnologia.