import React from 'react';
import { Star, Quote } from 'lucide-react';

const Testimonials = () => {
  const testimonials = [
    {
      name: 'Carlos Silva',
      role: 'Barbeiro há 15 anos',
      location: 'São Paulo, SP',
      image: 'https://images.pexels.com/photos/1043474/pexels-photo-1043474.jpeg',
      quote: 'Triplicou meu faturamento em 6 meses. Agora tenho agenda cheia e controle total dos clientes. Melhor investimento que já fiz!',
      rating: 5
    },
    {
      name: 'Roberto Santos',
      role: 'Dono da Barbearia Classic',
      location: 'Rio de Janeiro, RJ',
      image: 'https://images.pexels.com/photos/1121796/pexels-photo-1121796.jpeg',
      quote: 'Com 3 cadeiras funcionando, precisava de organização. O BarberPro resolveu todos meus problemas de agendamento.',
      rating: 5
    },
    {
      name: 'Fernando Costa',
      role: 'Barbeiro Especialista',
      location: 'Belo Horizonte, MG',
      image: 'https://images.pexels.com/photos/1040881/pexels-photo-1040881.jpeg',
      quote: 'Sistema simples de usar e clientes adoraram agendar pelo WhatsApp. Recomendo para todos os colegas barbeiros!',
      rating: 5
    },
    {
      name: 'André Oliveira',
      role: 'Barbearia Moderna',
      location: 'Porto Alegre, RS',
      image: 'https://images.pexels.com/photos/1040880/pexels-photo-1040880.jpeg',
      quote: 'Acabou a bagunça na agenda. Agora sei exatamente quantos clientes tenho, horário livre e ainda recebo no cartão.',
      rating: 5
    },
    {
      name: 'Diego Ferreira',
      role: 'Barbeiro Profissional',
      location: 'Salvador, BA',
      image: 'https://images.pexels.com/photos/1484794/pexels-photo-1484794.jpeg',
      quote: 'Interface linda e fácil. Meus clientes ficaram impressionados com o profissionalismo. Vale cada centavo!',
      rating: 5
    },
    {
      name: 'Lucas Martins',
      role: 'Studio Hair & Beard',
      location: 'Brasília, DF',
      image: 'https://images.pexels.com/photos/1043473/pexels-photo-1043473.jpeg',
      quote: 'Relatórios me ajudam a tomar decisões. Vejo horários de pico, clientes mais frequentes. Cresci 150% este ano!',
      rating: 5
    }
  ];

  return (
    <section id="depoimentos" className="py-20 bg-gray-900">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        {/* Header */}
        <div className="text-center mb-16">
          <h2 className="text-4xl md:text-5xl font-bold text-white mb-6">
            Barbeiros que já <span className="text-yellow-500">transformaram</span> seus negócios
          </h2>
          <p className="text-xl text-gray-400 max-w-3xl mx-auto">
            Mais de 5.000 barbeiros confiam no BarberPro para gerenciar seus agendamentos
          </p>
        </div>

        {/* Testimonials Grid */}
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
          {testimonials.map((testimonial, index) => (
            <div
              key={index}
              className="bg-black/50 border border-gray-800 rounded-xl p-6 hover:border-yellow-500/50 transition-all duration-300 transform hover:-translate-y-1"
            >
              {/* Quote Icon */}
              <div className="flex justify-between items-start mb-4">
                <Quote className="h-8 w-8 text-yellow-500/50" />
                <div className="flex space-x-1">
                  {[...Array(testimonial.rating)].map((_, i) => (
                    <Star key={i} className="h-4 w-4 text-yellow-500 fill-current" />
                  ))}
                </div>
              </div>

              {/* Quote */}
              <p className="text-gray-300 mb-6 leading-relaxed italic">
                "{testimonial.quote}"
              </p>

              {/* Author */}
              <div className="flex items-center space-x-4">
                <img
                  src={testimonial.image}
                  alt={testimonial.name}
                  className="w-12 h-12 rounded-full object-cover"
                />
                <div>
                  <h4 className="text-white font-semibold">{testimonial.name}</h4>
                  <p className="text-gray-400 text-sm">{testimonial.role}</p>
                  <p className="text-yellow-500 text-xs">{testimonial.location}</p>
                </div>
              </div>
            </div>
          ))}
        </div>

        {/* Stats Section */}
        <div className="mt-20 grid grid-cols-1 md:grid-cols-4 gap-8 text-center">
          <div className="bg-black/50 border border-gray-800 rounded-xl p-6">
            <div className="text-3xl font-bold text-yellow-500 mb-2">5.000+</div>
            <div className="text-gray-400">Barbeiros ativos</div>
          </div>
          <div className="bg-black/50 border border-gray-800 rounded-xl p-6">
            <div className="text-3xl font-bold text-yellow-500 mb-2">98%</div>
            <div className="text-gray-400">Taxa de satisfação</div>
          </div>
          <div className="bg-black/50 border border-gray-800 rounded-xl p-6">
            <div className="text-3xl font-bold text-yellow-500 mb-2">+2M</div>
            <div className="text-gray-400">Agendamentos realizados</div>
          </div>
          <div className="bg-black/50 border border-gray-800 rounded-xl p-6">
            <div className="text-3xl font-bold text-yellow-500 mb-2">24/7</div>
            <div className="text-gray-400">Suporte disponível</div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default Testimonials;