import React from 'react';
import { Check, Star, Zap, Shield } from 'lucide-react';

const Pricing = () => {
  const plans = [
    {
      name: 'Básico',
      price: '49',
      description: 'Perfeito para começar',
      icon: Check,
      features: [
        'Até 200 agendamentos/mês',
        'Agenda online personalizada',
        'Notificações WhatsApp',
        'Controle de clientes',
        'Suporte por chat',
        'App mobile básico'
      ],
      buttonText: 'Começar Básico',
      popular: false
    },
    {
      name: 'Profissional',
      price: '89',
      description: 'O mais escolhido pelos barbeiros',
      icon: Star,
      features: [
        'Agendamentos ilimitados',
        'Múltiplos profissionais',
        'SMS + WhatsApp automático',
        'Relatórios avançados',
        'Integração com pagamentos',
        'Suporte prioritário',
        'App completo',
        'Backup automático'
      ],
      buttonText: 'Escolher Profissional',
      popular: true
    },
    {
      name: 'Premium',
      price: '149',
      description: 'Para barbearias de sucesso',
      icon: Zap,
      features: [
        'Tudo do Profissional +',
        'Múltiplas unidades',
        'API personalizada',
        'White label',
        'Consultoria de negócios',
        'Suporte 24/7',
        'Treinamento exclusivo',
        'Gerente de conta'
      ],
      buttonText: 'Ir Premium',
      popular: false
    }
  ];

  return (
    <section id="planos" className="py-20 bg-black">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        {/* Header */}
        <div className="text-center mb-16">
          <h2 className="text-4xl md:text-5xl font-bold text-white mb-6">
            Planos que <span className="text-yellow-500">cabem no seu bolso</span>
          </h2>
          <p className="text-xl text-gray-400 max-w-3xl mx-auto mb-8">
            Escolha o plano ideal para o tamanho da sua barbearia. Todos com 14 dias grátis para testar
          </p>
          <div className="inline-flex bg-gray-800 rounded-lg p-1">
            <button className="bg-yellow-500 text-black px-6 py-2 rounded-md font-semibold transition-all duration-200">
              Mensal
            </button>
            <button className="text-gray-400 hover:text-white px-6 py-2 rounded-md transition-colors duration-200">
              Anual (20% off)
            </button>
          </div>
        </div>

        {/* Plans Grid */}
        <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
          {plans.map((plan, index) => (
            <div
              key={index}
              className={`relative bg-gray-900 border-2 rounded-2xl p-8 transition-all duration-300 transform hover:-translate-y-2 ${
                plan.popular
                  ? 'border-yellow-500 scale-105'
                  : 'border-gray-800 hover:border-yellow-500/50'
              }`}
            >
              {/* Popular Badge */}
              {plan.popular && (
                <div className="absolute -top-4 left-1/2 transform -translate-x-1/2">
                  <div className="bg-yellow-500 text-black px-4 py-1 rounded-full text-sm font-bold">
                    MAIS POPULAR
                  </div>
                </div>
              )}

              {/* Plan Header */}
              <div className="text-center mb-8">
                <div className={`inline-flex p-3 rounded-lg mb-4 ${
                  plan.popular ? 'bg-yellow-500/20' : 'bg-gray-800'
                }`}>
                  <plan.icon className={`h-6 w-6 ${
                    plan.popular ? 'text-yellow-500' : 'text-gray-400'
                  }`} />
                </div>
                <h3 className="text-2xl font-bold text-white mb-2">{plan.name}</h3>
                <p className="text-gray-400 mb-4">{plan.description}</p>
                <div className="flex items-baseline justify-center">
                  <span className="text-5xl font-bold text-white">R${plan.price}</span>
                  <span className="text-gray-400 ml-2">/mês</span>
                </div>
              </div>

              {/* Features List */}
              <ul className="space-y-4 mb-8">
                {plan.features.map((feature, featureIndex) => (
                  <li key={featureIndex} className="flex items-start space-x-3">
                    <Check className="h-5 w-5 text-yellow-500 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-300">{feature}</span>
                  </li>
                ))}
              </ul>

              {/* CTA Button */}
              <button
                className={`w-full py-3 px-6 rounded-lg font-semibold transition-all duration-200 transform hover:scale-105 ${
                  plan.popular
                    ? 'bg-yellow-500 hover:bg-yellow-600 text-black'
                    : 'bg-gray-800 hover:bg-gray-700 text-white border border-gray-700 hover:border-yellow-500'
                }`}
              >
                {plan.buttonText}
              </button>
            </div>
          ))}
        </div>

        {/* Money Back Guarantee */}
        <div className="text-center mt-16">
          <div className="inline-flex items-center space-x-2 text-gray-400 mb-4">
            <Shield className="h-5 w-5 text-yellow-500" />
            <span>Garantia de 30 dias ou seu dinheiro de volta</span>
          </div>
          <p className="text-gray-500 text-sm">
            Não tem cartão? Sem problema! Pague via PIX ou boleto
          </p>
        </div>
      </div>
    </section>
  );
};

export default Pricing;