import React from 'react';
import { Calendar, ArrowRight } from 'lucide-react';

const Hero = () => {
  return (
    <section
      id="inicio"
      className="relative min-h-screen flex items-center justify-center bg-gradient-to-br from-black via-gray-900 to-black"
      style={{
        backgroundImage: 'linear-gradient(rgba(0, 0, 0, 0.7), rgba(0, 0, 0, 0.8)), url("https://images.pexels.com/photos/1319460/pexels-photo-1319460.jpeg")',
        backgroundSize: 'cover',
        backgroundPosition: 'center',
        backgroundAttachment: 'fixed'
      }}
    >
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-32">
        <div className="text-center">
          {/* Badge */}
          <div className="inline-flex items-center space-x-2 bg-yellow-500/10 border border-yellow-500/20 rounded-full px-4 py-2 mb-8">
            <Calendar className="h-4 w-4 text-yellow-500" />
            <span className="text-yellow-500 text-sm font-medium">Sistema Nº1 em Agendamentos</span>
          </div>

          {/* Main Heading */}
          <h1 className="text-4xl md:text-6xl lg:text-7xl font-bold text-white leading-tight mb-6">
            Seu salão <span className="text-yellow-500">organizado</span>,<br />
            clientes <span className="text-yellow-500">felizes</span> e<br />
            agenda <span className="text-yellow-500">lotada</span>
          </h1>

          {/* Subtitle */}
          <p className="text-xl md:text-2xl text-gray-300 max-w-3xl mx-auto mb-10 leading-relaxed">
            Venda mais tempo e menos dor de cabeça com o sistema de agendamentos 
            para barbearia mais completo do mercado
          </p>

          {/* CTA Buttons */}
          <div className="flex flex-col sm:flex-row items-center justify-center space-y-4 sm:space-y-0 sm:space-x-6">
            <button className="group bg-yellow-500 hover:bg-yellow-600 text-black font-bold px-8 py-4 rounded-lg text-lg transition-all duration-200 transform hover:scale-105 flex items-center space-x-2">
              <span>Solicitar Demonstração</span>
              <ArrowRight className="h-5 w-5 group-hover:translate-x-1 transition-transform duration-200" />
            </button>
            <button className="border-2 border-white hover:border-yellow-500 text-white hover:text-yellow-500 font-semibold px-8 py-4 rounded-lg text-lg transition-all duration-200 hover:bg-white/5">
              Ver Funcionalidades
            </button>
          </div>

          {/* Stats */}
          <div className="grid grid-cols-1 md:grid-cols-3 gap-8 mt-16 pt-16 border-t border-gray-800">
            <div className="text-center">
              <div className="text-3xl md:text-4xl font-bold text-yellow-500 mb-2">5.000+</div>
              <div className="text-gray-400">Barbearias ativas</div>
            </div>
            <div className="text-center">
              <div className="text-3xl md:text-4xl font-bold text-yellow-500 mb-2">98%</div>
              <div className="text-gray-400">Taxa de satisfação</div>
            </div>
            <div className="text-center">
              <div className="text-3xl md:text-4xl font-bold text-yellow-500 mb-2">24/7</div>
              <div className="text-gray-400">Suporte disponível</div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default Hero;