import React, { useState } from 'react';
import { Menu, X, Scissors } from 'lucide-react';

const Header = () => {
  const [isMenuOpen, setIsMenuOpen] = useState(false);

  const toggleMenu = () => {
    setIsMenuOpen(!isMenuOpen);
  };

  return (
    <header className="fixed w-full top-0 bg-black/95 backdrop-blur-sm border-b border-gray-800 z-50">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="flex justify-between items-center h-16">
          {/* Logo */}
          <div className="flex items-center space-x-2">
            <div className="bg-yellow-500 p-2 rounded-lg">
              <Scissors className="h-6 w-6 text-black" />
            </div>
            <span className="text-2xl font-bold text-white">
              Barber<span className="text-yellow-500">Pro</span>
            </span>
          </div>

          {/* Desktop Menu */}
          <nav className="hidden md:flex items-center space-x-8">
            <a href="#inicio" className="text-gray-300 hover:text-yellow-500 transition-colors duration-200">
              Início
            </a>
            <a href="#recursos" className="text-gray-300 hover:text-yellow-500 transition-colors duration-200">
              Recursos
            </a>
            <a href="#planos" className="text-gray-300 hover:text-yellow-500 transition-colors duration-200">
              Planos
            </a>
            <a href="#depoimentos" className="text-gray-300 hover:text-yellow-500 transition-colors duration-200">
              Depoimentos
            </a>
            <a href="#contato" className="text-gray-300 hover:text-yellow-500 transition-colors duration-200">
              Contato
            </a>
          </nav>

          {/* CTA Button */}
          <div className="hidden md:block">
            <button className="bg-yellow-500 hover:bg-yellow-600 text-black font-semibold px-6 py-2 rounded-lg transition-all duration-200 transform hover:scale-105">
              Testar Agora
            </button>
          </div>

          {/* Mobile Menu Button */}
          <div className="md:hidden">
            <button
              onClick={toggleMenu}
              className="text-gray-300 hover:text-white transition-colors duration-200"
            >
              {isMenuOpen ? <X className="h-6 w-6" /> : <Menu className="h-6 w-6" />}
            </button>
          </div>
        </div>

        {/* Mobile Menu */}
        {isMenuOpen && (
          <div className="md:hidden">
            <div className="px-2 pt-2 pb-3 space-y-1 bg-gray-900 rounded-lg mt-2">
              <a
                href="#inicio"
                className="block px-3 py-2 text-gray-300 hover:text-yellow-500 transition-colors duration-200"
                onClick={() => setIsMenuOpen(false)}
              >
                Início
              </a>
              <a
                href="#recursos"
                className="block px-3 py-2 text-gray-300 hover:text-yellow-500 transition-colors duration-200"
                onClick={() => setIsMenuOpen(false)}
              >
                Recursos
              </a>
              <a
                href="#planos"
                className="block px-3 py-2 text-gray-300 hover:text-yellow-500 transition-colors duration-200"
                onClick={() => setIsMenuOpen(false)}
              >
                Planos
              </a>
              <a
                href="#depoimentos"
                className="block px-3 py-2 text-gray-300 hover:text-yellow-500 transition-colors duration-200"
                onClick={() => setIsMenuOpen(false)}
              >
                Depoimentos
              </a>
              <a
                href="#contato"
                className="block px-3 py-2 text-gray-300 hover:text-yellow-500 transition-colors duration-200"
                onClick={() => setIsMenuOpen(false)}
              >
                Contato
              </a>
              <div className="pt-2">
                <button className="w-full bg-yellow-500 hover:bg-yellow-600 text-black font-semibold px-4 py-2 rounded-lg transition-colors duration-200">
                  Testar Agora
                </button>
              </div>
            </div>
          </div>
        )}
      </div>
    </header>
  );
};

export default Header;