import React from 'react';
import { Scissors, Instagram, Phone, Mail, MapPin } from 'lucide-react';

const Footer = () => {
  const quickLinks = [
    { name: 'Início', href: '#inicio' },
    { name: 'Recursos', href: '#recursos' },
    { name: 'Planos', href: '#planos' },
    { name: 'Depoimentos', href: '#depoimentos' },
    { name: 'Contato', href: '#contato' }
  ];

  const legalLinks = [
    { name: 'Política de Privacidade', href: '#' },
    { name: 'Termos de Uso', href: '#' },
    { name: 'FAQ', href: '#' },
    { name: 'Suporte', href: '#' }
  ];

  return (
    <footer className="bg-black border-t border-gray-800">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        {/* Main Footer Content */}
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8 py-12">
          {/* Brand Section */}
          <div className="lg:col-span-2">
            <div className="flex items-center space-x-2 mb-6">
              <div className="bg-yellow-500 p-2 rounded-lg">
                <Scissors className="h-6 w-6 text-black" />
              </div>
              <span className="text-2xl font-bold text-white">
                Barber<span className="text-yellow-500">Pro</span>
              </span>
            </div>
            <p className="text-gray-400 max-w-md mb-6 leading-relaxed">
              O sistema de agendamentos mais completo para barbearias. 
              Organize sua agenda, aumente seu faturamento e ofereça 
              a melhor experiência para seus clientes.
            </p>
            
            {/* Social Media */}
            <div className="flex space-x-4">
              <a
                href="#"
                className="bg-gray-800 hover:bg-yellow-500 text-gray-400 hover:text-black p-3 rounded-lg transition-all duration-200 transform hover:scale-110"
              >
                <Instagram className="h-5 w-5" />
              </a>
              <a
                href="#"
                className="bg-gray-800 hover:bg-yellow-500 text-gray-400 hover:text-black p-3 rounded-lg transition-all duration-200 transform hover:scale-110"
              >
                <Phone className="h-5 w-5" />
              </a>
              <a
                href="#"
                className="bg-gray-800 hover:bg-yellow-500 text-gray-400 hover:text-black p-3 rounded-lg transition-all duration-200 transform hover:scale-110"
              >
                <Mail className="h-5 w-5" />
              </a>
            </div>
          </div>

          {/* Quick Links */}
          <div>
            <h3 className="text-white font-bold text-lg mb-6">Links Rápidos</h3>
            <ul className="space-y-4">
              {quickLinks.map((link, index) => (
                <li key={index}>
                  <a
                    href={link.href}
                    className="text-gray-400 hover:text-yellow-500 transition-colors duration-200 hover:underline"
                  >
                    {link.name}
                  </a>
                </li>
              ))}
            </ul>
          </div>

          {/* Legal & Support */}
          <div>
            <h3 className="text-white font-bold text-lg mb-6">Suporte</h3>
            <ul className="space-y-4">
              {legalLinks.map((link, index) => (
                <li key={index}>
                  <a
                    href={link.href}
                    className="text-gray-400 hover:text-yellow-500 transition-colors duration-200 hover:underline"
                  >
                    {link.name}
                  </a>
                </li>
              ))}
            </ul>
            
            {/* Contact Info */}
            <div className="mt-8 space-y-3">
              <div className="flex items-center space-x-2 text-gray-400">
                <Phone className="h-4 w-4" />
                <span className="text-sm">(11) 99999-9999</span>
              </div>
              <div className="flex items-center space-x-2 text-gray-400">
                <Mail className="h-4 w-4" />
                <span className="text-sm">contato@barberpro.com.br</span>
              </div>
              <div className="flex items-center space-x-2 text-gray-400">
                <MapPin className="h-4 w-4" />
                <span className="text-sm">São Paulo, SP</span>
              </div>
            </div>
          </div>
        </div>

        {/* CTA Section */}
        <div className="border-t border-gray-800 py-8">
          <div className="bg-gradient-to-r from-yellow-500/10 to-yellow-600/10 border border-yellow-500/20 rounded-xl p-6 text-center">
            <h3 className="text-2xl font-bold text-white mb-4">
              Comece hoje mesmo a transformar sua barbearia!
            </h3>
            <div className="flex flex-col sm:flex-row items-center justify-center space-y-4 sm:space-y-0 sm:space-x-4">
              <button className="bg-yellow-500 hover:bg-yellow-600 text-black font-bold px-8 py-3 rounded-lg transition-all duration-200 transform hover:scale-105">
                Teste 14 Dias Grátis
              </button>
              <button className="border border-yellow-500 hover:bg-yellow-500 text-yellow-500 hover:text-black font-semibold px-8 py-3 rounded-lg transition-all duration-200">
                Falar com Consultor
              </button>
            </div>
          </div>
        </div>

        {/* Bottom Bar */}
        <div className="border-t border-gray-800 py-6">
          <div className="flex flex-col md:flex-row items-center justify-between">
            <p className="text-gray-500 text-sm mb-4 md:mb-0">
              © 2025 BarberPro. Todos os direitos reservados.
            </p>
            <div className="flex items-center space-x-6 text-sm text-gray-500">
              <span>CNPJ: 00.000.000/0001-00</span>
              <span>•</span>
              <span>Desenvolvido com ❤️ para barbeiros</span>
            </div>
          </div>
        </div>
      </div>
    </footer>
  );
};

export default Footer;