import React from 'react';
import { Calendar, Users, Bell, BarChart3, Clock, Shield, Smartphone, CreditCard } from 'lucide-react';

const Features = () => {
  const features = [
    {
      icon: Calendar,
      title: 'Agendamento Online Fácil',
      description: 'Seus clientes podem agendar 24/7 através de um link personalizado, sem complicações.'
    },
    {
      icon: Users,
      title: 'Controle Total de Clientes',
      description: 'Histórico completo, preferências, fotos do antes/depois e muito mais em um só lugar.'
    },
    {
      icon: Bell,
      title: 'Notificações Automáticas',
      description: 'WhatsApp e SMS automáticos para confirmação, lembrete e pós-atendimento.'
    },
    {
      icon: BarChart3,
      title: 'Relatórios e Estatísticas',
      description: 'Acompanhe faturamento, clientes mais ativos, horários de pico e crescimento do negócio.'
    },
    {
      icon: Clock,
      title: 'Gestão de Horários',
      description: 'Configure intervalos, bloqueios, horários especiais e gerencie múltiplos profissionais.'
    },
    {
      icon: Shield,
      title: 'Segurança Total',
      description: 'Seus dados protegidos com criptografia e backup automático na nuvem.'
    },
    {
      icon: Smartphone,
      title: 'App Mobile Completo',
      description: 'Gerencie sua barbearia direto do celular, onde estiver e quando precisar.'
    },
    {
      icon: CreditCard,
      title: 'Pagamentos Integrados',
      description: 'Receba por PIX, cartão ou dinheiro e tenha controle financeiro total.'
    }
  ];

  return (
    <section id="recursos" className="py-20 bg-gray-900">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        {/* Header */}
        <div className="text-center mb-16">
          <h2 className="text-4xl md:text-5xl font-bold text-white mb-6">
            Recursos que fazem a <span className="text-yellow-500">diferença</span>
          </h2>
          <p className="text-xl text-gray-400 max-w-3xl mx-auto">
            Tudo que você precisa para transformar sua barbearia em um negócio mais organizado e lucrativo
          </p>
        </div>

        {/* Features Grid */}
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
          {features.map((feature, index) => (
            <div
              key={index}
              className="group bg-black/50 hover:bg-black/70 border border-gray-800 hover:border-yellow-500/50 rounded-xl p-6 transition-all duration-300 transform hover:-translate-y-2"
            >
              <div className="bg-yellow-500/10 group-hover:bg-yellow-500/20 w-16 h-16 rounded-lg flex items-center justify-center mb-4 transition-colors duration-300">
                <feature.icon className="h-8 w-8 text-yellow-500" />
              </div>
              <h3 className="text-xl font-bold text-white mb-3 group-hover:text-yellow-500 transition-colors duration-300">
                {feature.title}
              </h3>
              <p className="text-gray-400 leading-relaxed">
                {feature.description}
              </p>
            </div>
          ))}
        </div>

        {/* CTA Section */}
        <div className="text-center mt-16">
          <div className="bg-gradient-to-r from-yellow-500/10 to-yellow-600/10 border border-yellow-500/20 rounded-2xl p-8">
            <h3 className="text-3xl font-bold text-white mb-4">
              Pronto para revolucionar sua barbearia?
            </h3>
            <p className="text-gray-300 mb-6 max-w-2xl mx-auto">
              Junte-se a milhares de barbeiros que já transformaram seus negócios com o BarberPro
            </p>
            <button className="bg-yellow-500 hover:bg-yellow-600 text-black font-bold px-8 py-3 rounded-lg transition-all duration-200 transform hover:scale-105">
              Começar Agora - É Grátis
            </button>
          </div>
        </div>
      </div>
    </section>
  );
};

export default Features;